/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.guice;

import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.handler.ReflectorServletProcessor;

@Singleton
public class AtmosphereGuiceServlet
extends AtmosphereServlet {
    private static final String GUICE_FILTER = "com.google.inject.servlet.GuiceFilter";

    protected boolean detectJerseyRuntime(ServletConfig sc) {
        Injector injector = (Injector)this.config.getServletContext().getAttribute(Injector.class.getName());
        GuiceContainer guiceServlet = (GuiceContainer)injector.getInstance(GuiceContainer.class);
        this.setUseStreamForFlushingComments(false);
        ReflectorServletProcessor rsp = new ReflectorServletProcessor();
        this.setDefaultBroadcasterClassName("org.atmosphere.jersey.JerseyBroadcaster");
        this.setUseStreamForFlushingComments(true);
        rsp.setServlet((Servlet)guiceServlet);
        rsp.setFilterClassName(GUICE_FILTER);
        this.config = this.newAtmosphereConfig(false);
        String mapping = sc.getInitParameter("org.atmosphere.jersey.servlet-mapping");
        if (mapping == null) {
            mapping = "/*";
        }
        this.addAtmosphereHandler(mapping, (AtmosphereHandler)rsp);
        return true;
    }
}

