/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.handler.ReflectorServletProcessor;

public class AtmosphereGuiceServlet
extends AtmosphereServlet {
    public static final String JERSEY_PROPERTIES = AtmosphereGuiceServlet.class.getName() + ".properties";
    private static final String GUICE_FILTER = "com.google.inject.servlet.GuiceFilter";

    protected boolean detectJerseyRuntime(ServletConfig sc) {
        Map props;
        Injector injector = (Injector)this.config.getServletContext().getAttribute(Injector.class.getName());
        GuiceContainer guiceServlet = (GuiceContainer)injector.getInstance(GuiceContainer.class);
        this.setUseStreamForFlushingComments(false);
        ReflectorServletProcessor rsp = new ReflectorServletProcessor();
        this.setDefaultBroadcasterClassName("org.atmosphere.jersey.JerseyBroadcaster");
        this.setUseStreamForFlushingComments(true);
        rsp.setServlet((Servlet)guiceServlet);
        rsp.setFilterClassName(GUICE_FILTER);
        this.config = this.newAtmosphereConfig(false);
        String mapping = sc.getInitParameter("org.atmosphere.jersey.servlet-mapping");
        if (mapping == null) {
            mapping = "/*";
        }
        if ((props = (Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, String>>(){}, (Annotation)Names.named((String)JERSEY_PROPERTIES)))) != null) {
            for (String p : props.keySet()) {
                this.addInitParameter(p, (String)props.get(p));
            }
        }
        this.addAtmosphereHandler(mapping, (AtmosphereHandler)rsp);
        return true;
    }
}

