/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GuiceManagedAtmosphereServlet
extends AtmosphereServlet {
    private static final Logger logger = LoggerFactory.getLogger(GuiceManagedAtmosphereServlet.class);
    public static final String JERSEY_PROPERTIES = GuiceManagedAtmosphereServlet.class.getName() + ".properties";

    protected boolean detectSupportedFramework(ServletConfig sc) {
        Injector injector = (Injector)this.config.getServletContext().getAttribute(Injector.class.getName());
        GuiceContainer guiceServlet = (GuiceContainer)injector.getInstance(GuiceContainer.class);
        this.setUseStreamForFlushingComments(false);
        ReflectorServletProcessor rsp = new ReflectorServletProcessor();
        GuiceManagedAtmosphereServlet.setDefaultBroadcasterClassName((String)"org.atmosphere.jersey.JerseyBroadcaster");
        this.setUseStreamForFlushingComments(true);
        rsp.setServlet((Servlet)guiceServlet);
        this.getAtmosphereConfig().setSupportSession(false);
        String mapping = sc.getInitParameter("org.atmosphere.jersey.servlet-mapping");
        if (mapping == null) {
            mapping = "/*";
        }
        try {
            Map props = (Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, String>>(){}, (Annotation)Names.named((String)JERSEY_PROPERTIES)));
            if (props != null) {
                for (String p : props.keySet()) {
                    this.addInitParameter(p, (String)props.get(p));
                }
            }
        }
        catch (Exception ex) {
            logger.debug("failed to add Jersey init parameters to Atmosphere servlet", (Throwable)ex);
        }
        this.addAtmosphereHandler(mapping, (AtmosphereHandler)rsp);
        return true;
    }
}

