/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.guice.GuiceContainer;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereGuiceServlet
extends AtmosphereServlet {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereGuiceServlet.class);
    public static final String JERSEY_PROPERTIES = AtmosphereGuiceServlet.class.getName() + ".properties";
    private static final String GUICE_FILTER = "com.google.inject.servlet.GuiceFilter";
    protected static final String SKIP_GUICE_FILTER = "SkipGuiceFilter";
    private boolean guiceInstalled = false;

    protected void loadConfiguration(ServletConfig sc) throws ServletException {
        super.framework().loadConfiguration(sc);
        if (!this.guiceInstalled) {
            this.detectSupportedFramework(sc);
        }
    }

    protected boolean detectSupportedFramework(ServletConfig sc) {
        Injector injector = (Injector)this.framework().getAtmosphereConfig().getServletContext().getAttribute(Injector.class.getName());
        GuiceContainer guiceServlet = (GuiceContainer)((Object)injector.getInstance(GuiceContainer.class));
        this.framework().setUseStreamForFlushingComments(false);
        ReflectorServletProcessor rsp = new ReflectorServletProcessor();
        this.framework().setDefaultBroadcasterClassName("org.atmosphere.jersey.JerseyBroadcaster");
        this.framework().setUseStreamForFlushingComments(true);
        rsp.setServlet((Servlet)guiceServlet);
        if (sc.getServletContext().getAttribute(SKIP_GUICE_FILTER) == null) {
            rsp.setFilterClassName(GUICE_FILTER);
        }
        this.framework().getAtmosphereConfig().setSupportSession(false);
        String mapping = sc.getInitParameter("org.atmosphere.jersey.servlet-mapping");
        if (mapping == null) {
            mapping = "/*";
        }
        try {
            Map props = (Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, String>>(){}, (Annotation)Names.named((String)JERSEY_PROPERTIES)));
            if (props != null) {
                for (String p : props.keySet()) {
                    this.framework().addInitParameter(p, (String)props.get(p));
                }
            }
        }
        catch (Exception ex) {
            logger.debug("failed to add Jersey init parameters to Atmosphere servlet", (Throwable)ex);
        }
        this.framework().addAtmosphereHandler(mapping, (AtmosphereHandler)rsp);
        this.guiceInstalled = true;
        return true;
    }
}

