/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.guice.GuiceContainer;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereGuiceServlet
extends AtmosphereServlet {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereGuiceServlet.class);
    public static final String JERSEY_PROPERTIES = AtmosphereGuiceServlet.class.getName() + ".properties";
    private static final String GUICE_FILTER = "com.google.inject.servlet.GuiceFilter";
    private boolean guiceInstalled = false;

    public AtmosphereGuiceServlet() {
        this(false, true);
    }

    public AtmosphereGuiceServlet(boolean isFilter, boolean autoDetectHandlers) {
        this.framework = new AtmosphereFramework(isFilter, autoDetectHandlers){

            public void loadConfiguration(ServletConfig sc) throws ServletException {
                super.loadConfiguration(sc);
                if (!AtmosphereGuiceServlet.this.guiceInstalled) {
                    this.detectSupportedFramework(sc);
                }
            }

            protected boolean detectSupportedFramework(ServletConfig sc) {
                Injector injector = (Injector)AtmosphereGuiceServlet.this.framework().getAtmosphereConfig().getServletContext().getAttribute(Injector.class.getName());
                GuiceContainer guiceServlet = (GuiceContainer)((Object)injector.getInstance(GuiceContainer.class));
                this.setUseStreamForFlushingComments(false);
                ReflectorServletProcessor rsp = new ReflectorServletProcessor();
                boolean isJersey = false;
                try {
                    Thread.currentThread().getContextClassLoader().loadClass("com.sun.jersey.spi.container.servlet.ServletContainer");
                    this.setDefaultBroadcasterClassName(this.broadcasterClassName).setUseStreamForFlushingComments(true).getAtmosphereConfig().setSupportSession(false);
                    isJersey = true;
                }
                catch (Throwable t) {
                    // empty catch block
                }
                rsp.setServlet((Servlet)guiceServlet);
                String mapping = sc.getInitParameter("org.atmosphere.jersey.servlet-mapping");
                if (mapping == null) {
                    mapping = "/*";
                }
                if (isJersey) {
                    try {
                        Map props = (Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, String>>(){}, (Annotation)Names.named((String)JERSEY_PROPERTIES)));
                        if (props != null) {
                            for (String p : props.keySet()) {
                                AtmosphereGuiceServlet.this.framework().addInitParameter(p, (String)props.get(p));
                            }
                        }
                    }
                    catch (Exception ex) {
                        logger.debug("failed to add Jersey init parameters to Atmosphere servlet", (Throwable)ex);
                    }
                }
                this.addAtmosphereHandler(mapping, (AtmosphereHandler)rsp);
                AtmosphereGuiceServlet.this.guiceInstalled = true;
                return true;
            }
        };
    }
}

