/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereObjectFactory;
import org.atmosphere.guice.AtmosphereGuiceServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceObjectFactory
implements AtmosphereObjectFactory {
    private static final Logger logger = LoggerFactory.getLogger(GuiceObjectFactory.class);
    private static Injector injector;

    public <T> T newClassInstance(AtmosphereFramework framework, Class<T> classToInstantiate) throws InstantiationException, IllegalAccessException {
        this.initInjector(framework);
        if (injector == null) {
            logger.warn("No Guice Injector found in current ServletContext. Are you using {}?", (Object)AtmosphereGuiceServlet.class.getName());
            logger.trace("Unable to find {}. Creating the object directly.", (Object)classToInstantiate.getName());
            return classToInstantiate.newInstance();
        }
        return (T)injector.getInstance(classToInstantiate);
    }

    public String toString() {
        return "Guice ObjectFactory";
    }

    private void initInjector(AtmosphereFramework framework) {
        if (injector == null) {
            Injector servletInjector = (Injector)framework.getServletContext().getAttribute(Injector.class.getName());
            if (servletInjector != null) {
                injector = servletInjector;
            } else {
                logger.trace("Creating the Guice injector manually with an empty AbstractModule");
                injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                    protected void configure() {
                    }
                }});
            }
        }
    }
}

