/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.servlet.Servlet;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.guice.GuiceContainer;
import org.atmosphere.guice.GuiceObjectFactory;
import org.atmosphere.handler.ReflectorServletProcessor;

@Singleton
public class AtmosphereGuiceServlet
extends AtmosphereServlet {
    public static final String PROPERTIES = GuiceObjectFactory.class.getName() + ".properties";

    public AtmosphereGuiceServlet() {
        this(false, true);
    }

    public AtmosphereGuiceServlet(boolean isFilter, boolean autoDetectHandlers) {
        this.framework = new AtmosphereFramework(isFilter, autoDetectHandlers){

            protected void configureDetectedFramework(ReflectorServletProcessor rsp, boolean isJersey) {
                Injector injector = (Injector)AtmosphereGuiceServlet.this.framework().getAtmosphereConfig().getServletContext().getAttribute(Injector.class.getName());
                GuiceContainer guiceServlet = (GuiceContainer)((Object)injector.getInstance(GuiceContainer.class));
                rsp.setServlet((Servlet)guiceServlet);
                if (isJersey) {
                    try {
                        Map props = (Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, String>>(){}, (Annotation)Names.named((String)PROPERTIES)));
                        if (props != null) {
                            for (String p : props.keySet()) {
                                AtmosphereGuiceServlet.this.framework().addInitParameter(p, (String)props.get(p));
                            }
                        }
                    }
                    catch (Exception ex) {
                        logger.debug("failed to add Jersey init parameters to Atmosphere servlet", (Throwable)ex);
                    }
                }
            }
        };
    }
}

