/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.guice.GuiceContainer;
import org.atmosphere.guice.GuiceObjectFactory;
import org.atmosphere.handler.ReflectorServletProcessor;

@Singleton
public class AtmosphereGuiceServlet
extends AtmosphereServlet {
    public static final String PROPERTIES = GuiceObjectFactory.class.getName() + ".properties";

    protected AtmosphereServlet configureFramework(ServletConfig sc, boolean init) throws ServletException {
        this.initializer.configureFramework(sc, init, false, GuiceAtmosphereFramework.class);
        return this;
    }

    public final class GuiceAtmosphereFramework
    extends AtmosphereFramework {
        protected void configureDetectedFramework(ReflectorServletProcessor rsp, boolean isJersey) {
            if (isJersey) {
                Injector injector = (Injector)AtmosphereGuiceServlet.this.framework().getAtmosphereConfig().getServletContext().getAttribute(Injector.class.getName());
                GuiceContainer guiceServlet = (GuiceContainer)((Object)injector.getInstance(GuiceContainer.class));
                rsp.setServlet((Servlet)guiceServlet);
                try {
                    Map props = (Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, String>>(){}, (Annotation)Names.named((String)PROPERTIES)));
                    if (props != null) {
                        for (String p : props.keySet()) {
                            AtmosphereGuiceServlet.this.framework().addInitParameter(p, (String)props.get(p));
                        }
                    }
                }
                catch (Exception ex) {
                    logger.debug("failed to add Jersey init parameters to Atmosphere servlet", (Throwable)ex);
                }
            }
        }
    }
}

