/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereObjectFactory;
import org.atmosphere.cpr.AtmosphereResourceFactory;
import org.atmosphere.cpr.AtmosphereResourceSessionFactory;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.MetaBroadcaster;
import org.atmosphere.guice.AtmosphereGuiceServlet;
import org.atmosphere.inject.AtmosphereProducers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceObjectFactory
implements AtmosphereObjectFactory<AbstractModule> {
    private static final Logger logger = LoggerFactory.getLogger(GuiceObjectFactory.class);
    protected Injector injector;
    protected AtmosphereConfig config;
    private final List<AbstractModule> modules = new ArrayList<AbstractModule>();

    public void configure(AtmosphereConfig config) {
        if (config == null) {
            throw new NullPointerException("AtmosphereConfig can't be null");
        }
        this.config = config;
        this.modules.add(new AtmosphereModule());
        try {
            AtmosphereProducers p = this.newClassInstance(AtmosphereProducers.class, AtmosphereProducers.class);
            p.configure(config);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    public <T, U extends T> U newClassInstance(Class<T> classType, Class<U> classToInstantiate) throws InstantiationException, IllegalAccessException {
        Object t;
        this.initInjector(this.config.framework());
        if (this.injector != null) {
            t = this.injector.getInstance(classToInstantiate);
        } else {
            logger.warn("No Guice Injector found in current ServletContext. Are you using {}?", (Object)AtmosphereGuiceServlet.class.getName());
            logger.trace("Unable to find {}. Creating the object directly.", (Object)classToInstantiate.getName());
            t = classToInstantiate.newInstance();
        }
        return (U)t;
    }

    public String toString() {
        return "Guice ObjectFactory";
    }

    protected void initInjector(AtmosphereFramework framework) {
        if (this.injector == null) {
            Injector existingInjector = (Injector)framework.getServletContext().getAttribute(Injector.class.getName());
            AbstractModule[] a = this.modules.toArray(new AbstractModule[this.modules.size()]);
            if (existingInjector != null) {
                logger.trace("Adding AtmosphereModule to existing Guice injector");
                this.injector = existingInjector.createChildInjector((Module[])a);
            } else {
                logger.trace("Creating the Guice injector manually with AtmosphereModule");
                this.injector = Guice.createInjector((Module[])a);
            }
        }
    }

    public AtmosphereObjectFactory allowInjectionOf(AbstractModule module) {
        this.modules.add(module);
        return this;
    }

    private class AtmosphereModule
    extends AbstractModule {
        private AtmosphereModule() {
        }

        protected void configure() {
            this.bind(BroadcasterFactory.class).toProvider((Provider)new Provider<BroadcasterFactory>(){

                public BroadcasterFactory get() {
                    return GuiceObjectFactory.this.config.getBroadcasterFactory();
                }
            });
            this.bind(AtmosphereFramework.class).toProvider((Provider)new Provider<AtmosphereFramework>(){

                public AtmosphereFramework get() {
                    return GuiceObjectFactory.this.config.framework();
                }
            });
            this.bind(AtmosphereResourceFactory.class).toProvider((Provider)new Provider<AtmosphereResourceFactory>(){

                public AtmosphereResourceFactory get() {
                    return GuiceObjectFactory.this.config.resourcesFactory();
                }
            });
            this.bind(MetaBroadcaster.class).toProvider((Provider)new Provider<MetaBroadcaster>(){

                public MetaBroadcaster get() {
                    return GuiceObjectFactory.this.config.metaBroadcaster();
                }
            });
            this.bind(AtmosphereResourceSessionFactory.class).toProvider((Provider)new Provider<AtmosphereResourceSessionFactory>(){

                public AtmosphereResourceSessionFactory get() {
                    return GuiceObjectFactory.this.config.sessionFactory();
                }
            });
            this.bind(AtmosphereConfig.class).toProvider((Provider)new Provider<AtmosphereConfig>(){

                public AtmosphereConfig get() {
                    return GuiceObjectFactory.this.config;
                }
            });
        }
    }
}

