/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.guice.AtmosphereGuiceServlet;
import org.atmosphere.guice.GuiceContainer;
import org.atmosphere.handler.ReflectorServletProcessor;

public class GuiceAtmosphereFramework
extends AtmosphereFramework {
    public GuiceAtmosphereFramework() {
        this(false, true);
    }

    public GuiceAtmosphereFramework(ServletConfig sc) throws ServletException {
        super(false, true);
    }

    public GuiceAtmosphereFramework(boolean isFilter, boolean autoDetectHandlers) {
        super(isFilter, autoDetectHandlers);
    }

    protected void configureDetectedFramework(ReflectorServletProcessor rsp, boolean isJersey) {
        if (isJersey) {
            logger.info("Configuring Guice for Atmosphere Jersey");
            Injector injector = (Injector)this.getAtmosphereConfig().getServletContext().getAttribute(Injector.class.getName());
            GuiceContainer guiceServlet = (GuiceContainer)((Object)injector.getInstance(GuiceContainer.class));
            rsp.setServlet((Servlet)guiceServlet);
            try {
                Map props = (Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, String>>(){}, (Annotation)Names.named((String)AtmosphereGuiceServlet.PROPERTIES)));
                if (props != null) {
                    for (String p : props.keySet()) {
                        this.addInitParameter(p, (String)props.get(p));
                    }
                }
            }
            catch (Exception ex) {
                logger.debug("failed to add Jersey init parameters to Atmosphere servlet", ex.getCause());
            }
        }
    }
}

