/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.shared.impl.cldr;

// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "az" locale.
 */
public class DateTimeFormatInfoImpl_az extends DateTimeFormatInfoImpl {

  @Override
  public String dateFormatFull() {
    return "EEEE, d, MMMM, y";
  }

  @Override
  public String dateFormatLong() {
    return "d MMMM , y";
  }

  @Override
  public String dateFormatMedium() {
    return "d MMM, y";
  }

  @Override
  public String dateFormatShort() {
    return "yy/MM/dd";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "eramızdan əvvəl",
        "bizim eramızın"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "e.ə.",
        "b.e."
    };
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "d MMM , y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "d MMMM , y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, d, MMM, y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "Yanvar",
        "Fevral",
        "Mart",
        "Aprel",
        "May",
        "İyun",
        "İyul",
        "Avqust",
        "Sentyabr",
        "Oktyabr",
        "Noyabr",
        "Dekabr"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "1",
        "2",
        "3",
        "4",
        "5",
        "6",
        "7",
        "8",
        "9",
        "10",
        "11",
        "12"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "yan",
        "fev",
        "mar",
        "apr",
        "may",
        "iyn",
        "iyl",
        "avq",
        "sen",
        "okt",
        "noy",
        "dek"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "1-ci kvartal",
        "2-ci kvartal",
        "3-cü kvartal",
        "4-cü kvartal"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "1-ci kv.",
        "2-ci kv.",
        "3-cü kv.",
        "4-cü kv."
    };
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "bazar",
        "bazar ertəsi",
        "çərşənbə axşamı",
        "çərşənbə",
        "cümə axşamı",
        "cümə",
        "şənbə"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "7",
        "1",
        "2",
        "3",
        "4",
        "5",
        "6"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "B.",
        "B.E.",
        "Ç.A.",
        "Ç.",
        "C.A.",
        "C",
        "Ş."
    };
  }
}
