/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UUIDBroadcasterCache
implements BroadcasterCache {
    private static final Logger logger = LoggerFactory.getLogger(UUIDBroadcasterCache.class);
    private final Map<String, ClientQueue> messages = new HashMap<String, ClientQueue>();
    private final Map<String, Long> activeClients = new HashMap<String, Long>();
    private ScheduledFuture scheduledFuture;
    protected ScheduledExecutorService taskScheduler = Executors.newSingleThreadScheduledExecutor();
    private long clientIdleTime = TimeUnit.MINUTES.toMillis(2L);
    private long invalidateCacheInterval = TimeUnit.MINUTES.toMillis(1L);

    public void setInvalidateCacheInterval(long invalidateCacheInterval) {
        this.invalidateCacheInterval = invalidateCacheInterval;
        this.scheduledFuture.cancel(true);
        this.start();
    }

    public void setClientIdleTime(long clientIdleTime) {
        this.clientIdleTime = clientIdleTime;
    }

    public void setExecutorService(ScheduledExecutorService reaper) {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
        if (this.taskScheduler != null) {
            this.stop();
        }
        this.taskScheduler = reaper;
    }

    @Override
    public void start() {
        this.scheduledFuture = this.taskScheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                UUIDBroadcasterCache.this.invalidateExpiredEntries();
            }
        }, 0L, this.invalidateCacheInterval, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateExpiredEntries() {
        long now = System.currentTimeMillis();
        Map<String, ClientQueue> map = this.messages;
        synchronized (map) {
            HashSet<String> inactiveClients = new HashSet<String>();
            for (Map.Entry<String, Long> entry : this.activeClients.entrySet()) {
                if (now - entry.getValue() <= this.clientIdleTime) continue;
                logger.debug("Invalidate client {}", (Object)entry.getKey());
                inactiveClients.add(entry.getKey());
            }
            for (String clientId : inactiveClients) {
                this.activeClients.remove(clientId);
                this.messages.remove(clientId);
            }
        }
    }

    @Override
    public void stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
        this.taskScheduler.shutdown();
    }

    @Override
    public void addToCache(String broadcasterId, AtmosphereResource r, Object e) {
        this.addCacheCandidate(broadcasterId, r, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheMessage addCacheCandidate(String broadcasterId, AtmosphereResource r, Object e) {
        if (logger.isTraceEnabled()) {
            logger.trace("Adding for AtmosphereResource {} cached messages {}", (Object)(r != null ? r.uuid() : "null"), e);
            logger.trace("Active clients {}", this.activeClients());
        }
        long now = System.currentTimeMillis();
        String messageId = UUID.randomUUID().toString();
        CacheMessage cacheMessage = new CacheMessage(messageId, e);
        Map<String, ClientQueue> map = this.messages;
        synchronized (map) {
            if (r == null) {
                for (Map.Entry<String, Long> entry : this.activeClients.entrySet()) {
                    this.addMessageIfNotExists(entry.getKey(), cacheMessage);
                }
            } else {
                String clientId = this.uuid(r);
                this.activeClients.put(clientId, now);
                if (this.isAtmosphereResourceValid(r)) {
                    Broadcaster broadcaster = this.getBroadCaster(r.getAtmosphereConfig(), broadcasterId);
                    ArrayList<AtmosphereResource> resources = new ArrayList<AtmosphereResource>(broadcaster.getAtmosphereResources());
                    Set<String> disconnectedClients = this.getDisconnectedClients(resources);
                    for (String disconnectedId : disconnectedClients) {
                        this.addMessageIfNotExists(disconnectedId, cacheMessage);
                    }
                } else {
                    this.addMessageIfNotExists(clientId, cacheMessage);
                }
            }
        }
        return cacheMessage;
    }

    private String uuid(AtmosphereResource r) {
        return r.transport() == AtmosphereResource.TRANSPORT.WEBSOCKET ? (String)r.getRequest().getAttribute(ApplicationConfig.SUSPENDED_ATMOSPHERE_RESOURCE_UUID) : r.uuid();
    }

    private boolean isAtmosphereResourceValid(AtmosphereResource r) {
        return !r.isResumed() && !r.isCancelled() && ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).isInScope();
    }

    private Set<String> getDisconnectedClients(List<AtmosphereResource> resources) {
        HashSet<String> ids = new HashSet<String>(this.activeClients.keySet());
        for (AtmosphereResource resource : resources) {
            ids.remove(resource.uuid());
        }
        return ids;
    }

    private Broadcaster getBroadCaster(AtmosphereConfig config, String broadcasterId) {
        BroadcasterFactory factory = config.getBroadcasterFactory();
        Broadcaster broadcaster = factory.lookup(broadcasterId, false);
        return broadcaster;
    }

    private void addMessageIfNotExists(String clientId, CacheMessage message) {
        if (!this.hasMessage(clientId, message.getId())) {
            this.addMessage(clientId, message);
        } else {
            logger.debug("Duplicate message {} for client {}", (Object)clientId, (Object)message);
        }
    }

    private void addMessage(String clientId, CacheMessage message) {
        logger.debug("Adding message {} for client {}", (Object)clientId, (Object)message);
        ClientQueue clientQueue = this.messages.get(clientId);
        if (clientQueue == null) {
            clientQueue = new ClientQueue();
            this.messages.put(clientId, clientQueue);
        }
        clientQueue.getQueue().addLast(message);
        clientQueue.getIds().add(message.getId());
    }

    private boolean hasMessage(String clientId, String messageId) {
        ClientQueue clientQueue = this.messages.get(clientId);
        return clientQueue != null && clientQueue.getIds().contains(messageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> retrieveFromCache(String broadcasterId, AtmosphereResource r) {
        ClientQueue clientQueue;
        String clientId = r.uuid();
        long now = System.currentTimeMillis();
        ArrayList<Object> result = new ArrayList<Object>();
        Map<String, ClientQueue> map = this.messages;
        synchronized (map) {
            this.activeClients.put(clientId, now);
            clientQueue = this.messages.remove(clientId);
        }
        List<Object> clientMessages = clientQueue == null ? Collections.emptyList() : clientQueue.getQueue();
        for (CacheMessage cacheMessage : clientMessages) {
            result.add(cacheMessage.getMessage());
        }
        if (logger.isTraceEnabled()) {
            Map<String, ClientQueue> map2 = this.messages;
            synchronized (map2) {
                logger.trace("Retrieved for AtmosphereResource {} cached messages {}", (Object)r.uuid(), result);
                logger.trace("Available cached message {}", this.messages);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(String broadcasterId, AtmosphereResourceImpl r, CacheMessage message) {
        String clientId = this.uuid(r);
        Map<String, ClientQueue> map = this.messages;
        synchronized (map) {
            ClientQueue clientQueue = this.messages.get(clientId);
            if (clientQueue != null) {
                logger.debug("Removing for AtmosphereResource {} cached message {}", (Object)r.uuid(), message.getMessage());
                clientQueue.getQueue().remove(message);
            }
        }
    }

    public Map<String, ClientQueue> messages() {
        return this.messages;
    }

    public Map<String, Long> activeClients() {
        return this.activeClients;
    }

    public static class CacheMessage {
        private final Object message;
        private final String id;

        private CacheMessage(String id, Object message) {
            this.id = id;
            this.message = message;
        }

        public Object getMessage() {
            return this.message;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return this.message.toString();
        }
    }

    public static class ClientQueue {
        private final LinkedList<CacheMessage> queue = new LinkedList();
        private final Set<String> ids = new HashSet<String>();

        public LinkedList<CacheMessage> getQueue() {
            return this.queue;
        }

        public Set<String> getIds() {
            return this.ids;
        }

        public String toString() {
            return this.queue.toString();
        }
    }
}

