/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "fi" locale.
 */
public class LocalizedNamesImpl_fi extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "FI",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AX",
        "NL",
        "AN",
        "AL",
        "DZ",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AE",
        "AR",
        "AM",
        "AW",
        "AC",
        "AU",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "GB",
        "IO",
        "VG",
        "BN",
        "BG",
        "BF",
        "BI",
        "KY",
        "EA",
        "CL",
        "CP",
        "CK",
        "CR",
        "DG",
        "DJ",
        "DM",
        "DO",
        "EC",
        "EG",
        "SV",
        "ER",
        "ES",
        "ZA",
        "GS",
        "KR",
        "ET",
        "EU",
        "FK",
        "FJ",
        "PH",
        "FO",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GD",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "HN",
        "HK",
        "SJ",
        "ID",
        "IN",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "TL",
        "AT",
        "JM",
        "JP",
        "YE",
        "JE",
        "JO",
        "CX",
        "KH",
        "CM",
        "CA",
        "IC",
        "CV",
        "KZ",
        "KE",
        "CF",
        "CN",
        "KG",
        "KI",
        "CO",
        "KM",
        "CD",
        "CG",
        "CC",
        "GR",
        "HR",
        "CU",
        "KW",
        "CY",
        "LA",
        "LV",
        "LS",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "EH",
        "MO",
        "MG",
        "MK",
        "MW",
        "MV",
        "MY",
        "ML",
        "MT",
        "IM",
        "MA",
        "MH",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NI",
        "NE",
        "NG",
        "NU",
        "NF",
        "NO",
        "CI",
        "OM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "KP",
        "MP",
        "PT",
        "PR",
        "PL",
        "GQ",
        "QA",
        "FR",
        "FX",
        "GF",
        "PF",
        "TF",
        "RE",
        "RO",
        "RW",
        "SE",
        "BL",
        "SH",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "DE",
        "SB",
        "ZM",
        "WS",
        "SM",
        "ST",
        "SA",
        "SN",
        "RS",
        "CS",
        "SC",
        "SL",
        "SG",
        "SK",
        "SI",
        "SO",
        "LK",
        "SD",
        "FI",
        "SR",
        "SZ",
        "CH",
        "SY",
        "TJ",
        "TW",
        "TZ",
        "DK",
        "TH",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TD",
        "CZ",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "UG",
        "UA",
        "QO",
        "HU",
        "UY",
        "NC",
        "NZ",
        "UZ",
        "BY",
        "WF",
        "VU",
        "VA",
        "VE",
        "RU",
        "VN",
        "EE",
        "US",
        "VI",
        "UM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "maailma");
    namesMap.put("002", "Afrikka");
    namesMap.put("003", "Pohjois-Amerikka");
    namesMap.put("005", "Etelä-Amerikka");
    namesMap.put("009", "Oseania");
    namesMap.put("011", "Länsi-Afrikka");
    namesMap.put("013", "Väli-Amerikka");
    namesMap.put("014", "Itä-Afrikka");
    namesMap.put("015", "Pohjois-Afrikka");
    namesMap.put("017", "Keski-Afrikka");
    namesMap.put("018", "eteläinen Afrikka");
    namesMap.put("019", "Amerikka");
    namesMap.put("021", "pohjoinen Amerikka");
    namesMap.put("029", "Karibia");
    namesMap.put("030", "Itä-Aasia");
    namesMap.put("034", "Etelä-Aasia");
    namesMap.put("035", "Kaakkois-Aasia");
    namesMap.put("039", "Etelä-Eurooppa");
    namesMap.put("053", "Australia ja Uusi-Seelanti");
    namesMap.put("057", "Mikronesia");
    namesMap.put("062", "Etelä- ja Keski-Aasia");
    namesMap.put("142", "Aasia");
    namesMap.put("143", "Keski-Aasia");
    namesMap.put("145", "Länsi-Aasia");
    namesMap.put("150", "Eurooppa");
    namesMap.put("151", "Itä-Eurooppa");
    namesMap.put("154", "Pohjois-Eurooppa");
    namesMap.put("155", "Länsi-Eurooppa");
    namesMap.put("172", "Itsenäisten valtioiden yhteisö");
    namesMap.put("419", "Latinalainen Amerikka ja Karibia");
    namesMap.put("830", "Kanaalisaaret");
    namesMap.put("AC", "Ascension-saari");
    namesMap.put("AE", "Arabiemiirikunnat");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigua ja Barbuda");
    namesMap.put("AN", "Alankomaiden Antillit");
    namesMap.put("AQ", "Antarktis");
    namesMap.put("AR", "Argentiina");
    namesMap.put("AS", "Amerikan Samoa");
    namesMap.put("AT", "Itävalta");
    namesMap.put("AX", "Ahvenanmaa");
    namesMap.put("AZ", "Azerbaidžan");
    namesMap.put("BA", "Bosnia ja Hertsegovina");
    namesMap.put("BE", "Belgia");
    namesMap.put("BL", "Saint-Barthélemy");
    namesMap.put("BR", "Brasilia");
    namesMap.put("BS", "Bahama");
    namesMap.put("BV", "Bouvet’nsaari");
    namesMap.put("BY", "Valko-Venäjä");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kookossaaret");
    namesMap.put("CD", "Kongon demokraattinen tasavalta");
    namesMap.put("CF", "Keski-Afrikan tasavalta");
    namesMap.put("CG", "Kongon tasavalta");
    namesMap.put("CH", "Sveitsi");
    namesMap.put("CI", "Norsunluurannikko");
    namesMap.put("CK", "Cookinsaaret");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Kiina");
    namesMap.put("CO", "Kolumbia");
    namesMap.put("CP", "Clippertoninsaari");
    namesMap.put("CS", "Serbia ja Montenegro");
    namesMap.put("CU", "Kuuba");
    namesMap.put("CV", "Kap Verde");
    namesMap.put("CX", "Joulusaari");
    namesMap.put("CY", "Kypros");
    namesMap.put("CZ", "Tšekki");
    namesMap.put("DE", "Saksa");
    namesMap.put("DK", "Tanska");
    namesMap.put("DO", "Dominikaaninen tasavalta");
    namesMap.put("EA", "Ceuta ja Melilla");
    namesMap.put("EE", "Viro");
    namesMap.put("EG", "Egypti");
    namesMap.put("EH", "Länsi-Sahara");
    namesMap.put("ES", "Espanja");
    namesMap.put("ET", "Etiopia");
    namesMap.put("FI", "Suomi");
    namesMap.put("FJ", "Fidži");
    namesMap.put("FK", "Falklandinsaaret");
    namesMap.put("FM", "Mikronesian liittovaltio");
    namesMap.put("FO", "Färsaaret");
    namesMap.put("FR", "Ranska");
    namesMap.put("FX", "Ranskan Eurooppaan kuuluvat osat");
    namesMap.put("GB", "Britannia");
    namesMap.put("GF", "Ranskan Guayana");
    namesMap.put("GL", "Grönlanti");
    namesMap.put("GQ", "Päiväntasaajan Guinea");
    namesMap.put("GR", "Kreikka");
    namesMap.put("GS", "Etelä-Georgia ja Eteläiset Sandwichsaaret");
    namesMap.put("HK", "Hongkong");
    namesMap.put("HM", "Heard- ja McDonaldinsaaret");
    namesMap.put("HR", "Kroatia");
    namesMap.put("HU", "Unkari");
    namesMap.put("IC", "Kanariansaaret");
    namesMap.put("IE", "Irlanti");
    namesMap.put("IM", "Mansaari");
    namesMap.put("IN", "Intia");
    namesMap.put("IO", "Brittiläinen Intian valtameren alue");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Islanti");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Jordania");
    namesMap.put("JP", "Japani");
    namesMap.put("KE", "Kenia");
    namesMap.put("KG", "Kirgisia");
    namesMap.put("KH", "Kambodža");
    namesMap.put("KM", "Komorit");
    namesMap.put("KN", "Saint Kitts ja Nevis");
    namesMap.put("KP", "Pohjois-Korea");
    namesMap.put("KR", "Etelä-Korea");
    namesMap.put("KY", "Caymansaaret");
    namesMap.put("KZ", "Kazakstan");
    namesMap.put("LB", "Libanon");
    namesMap.put("LT", "Liettua");
    namesMap.put("LU", "Luxemburg");
    namesMap.put("MA", "Marokko");
    namesMap.put("MF", "Saint-Martin");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshallinsaaret");
    namesMap.put("MK", "Makedonia");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MO", "Macao");
    namesMap.put("MP", "Pohjois-Mariaanit");
    namesMap.put("MV", "Malediivit");
    namesMap.put("MX", "Meksiko");
    namesMap.put("MY", "Malesia");
    namesMap.put("MZ", "Mosambik");
    namesMap.put("NC", "Uusi-Kaledonia");
    namesMap.put("NF", "Norfolkinsaari");
    namesMap.put("NL", "Alankomaat");
    namesMap.put("NO", "Norja");
    namesMap.put("NZ", "Uusi-Seelanti");
    namesMap.put("PF", "Ranskan Polynesia");
    namesMap.put("PG", "Papua-Uusi-Guinea");
    namesMap.put("PH", "Filippiinit");
    namesMap.put("PL", "Puola");
    namesMap.put("PM", "Saint-Pierre ja Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PS", "Palestiina");
    namesMap.put("PT", "Portugali");
    namesMap.put("QO", "ulkomeri");
    namesMap.put("RU", "Venäjä");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Saudi-Arabia");
    namesMap.put("SB", "Salomonsaaret");
    namesMap.put("SC", "Seychellit");
    namesMap.put("SE", "Ruotsi");
    namesMap.put("SJ", "Huippuvuoret ja Jan Mayen");
    namesMap.put("SR", "Surinam");
    namesMap.put("ST", "São Tomé ja Príncipe");
    namesMap.put("SY", "Syyria");
    namesMap.put("SZ", "Swazimaa");
    namesMap.put("TC", "Turks- ja Caicossaaret");
    namesMap.put("TD", "Tšad");
    namesMap.put("TF", "Ranskan ulkopuoliset eteläiset alueet");
    namesMap.put("TH", "Thaimaa");
    namesMap.put("TJ", "Tadžikistan");
    namesMap.put("TL", "Itä-Timor");
    namesMap.put("TR", "Turkki");
    namesMap.put("TT", "Trinidad ja Tobago");
    namesMap.put("TZ", "Tansania");
    namesMap.put("UA", "Ukraina");
    namesMap.put("UM", "Yhdysvaltain pienet erillissaaret");
    namesMap.put("US", "Yhdysvallat");
    namesMap.put("VA", "Vatikaani");
    namesMap.put("VC", "Saint Vincent ja Grenadiinit");
    namesMap.put("VG", "Brittiläiset Neitsytsaaret");
    namesMap.put("VI", "Yhdysvaltain Neitsytsaaret");
    namesMap.put("WF", "Wallis ja Futuna");
    namesMap.put("YE", "Jemen");
    namesMap.put("ZA", "Etelä-Afrikka");
    namesMap.put("ZM", "Sambia");
    namesMap.put("ZZ", "tuntematon tai virheellinen alue");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "maailma",
        "002": "Afrikka",
        "003": "Pohjois-Amerikka",
        "005": "Etelä-Amerikka",
        "009": "Oseania",
        "011": "Länsi-Afrikka",
        "013": "Väli-Amerikka",
        "014": "Itä-Afrikka",
        "015": "Pohjois-Afrikka",
        "017": "Keski-Afrikka",
        "018": "eteläinen Afrikka",
        "019": "Amerikka",
        "021": "pohjoinen Amerikka",
        "029": "Karibia",
        "030": "Itä-Aasia",
        "034": "Etelä-Aasia",
        "035": "Kaakkois-Aasia",
        "039": "Etelä-Eurooppa",
        "053": "Australia ja Uusi-Seelanti",
        "057": "Mikronesia",
        "062": "Etelä- ja Keski-Aasia",
        "142": "Aasia",
        "143": "Keski-Aasia",
        "145": "Länsi-Aasia",
        "150": "Eurooppa",
        "151": "Itä-Eurooppa",
        "154": "Pohjois-Eurooppa",
        "155": "Länsi-Eurooppa",
        "172": "Itsenäisten valtioiden yhteisö",
        "419": "Latinalainen Amerikka ja Karibia",
        "830": "Kanaalisaaret",
        "AC": "Ascension-saari",
        "AE": "Arabiemiirikunnat",
        "AF": "Afganistan",
        "AG": "Antigua ja Barbuda",
        "AN": "Alankomaiden Antillit",
        "AQ": "Antarktis",
        "AR": "Argentiina",
        "AS": "Amerikan Samoa",
        "AT": "Itävalta",
        "AX": "Ahvenanmaa",
        "AZ": "Azerbaidžan",
        "BA": "Bosnia ja Hertsegovina",
        "BE": "Belgia",
        "BL": "Saint-Barthélemy",
        "BR": "Brasilia",
        "BS": "Bahama",
        "BV": "Bouvet’nsaari",
        "BY": "Valko-Venäjä",
        "CA": "Kanada",
        "CC": "Kookossaaret",
        "CD": "Kongon demokraattinen tasavalta",
        "CF": "Keski-Afrikan tasavalta",
        "CG": "Kongon tasavalta",
        "CH": "Sveitsi",
        "CI": "Norsunluurannikko",
        "CK": "Cookinsaaret",
        "CM": "Kamerun",
        "CN": "Kiina",
        "CO": "Kolumbia",
        "CP": "Clippertoninsaari",
        "CS": "Serbia ja Montenegro",
        "CU": "Kuuba",
        "CV": "Kap Verde",
        "CX": "Joulusaari",
        "CY": "Kypros",
        "CZ": "Tšekki",
        "DE": "Saksa",
        "DK": "Tanska",
        "DO": "Dominikaaninen tasavalta",
        "EA": "Ceuta ja Melilla",
        "EE": "Viro",
        "EG": "Egypti",
        "EH": "Länsi-Sahara",
        "ES": "Espanja",
        "ET": "Etiopia",
        "FI": "Suomi",
        "FJ": "Fidži",
        "FK": "Falklandinsaaret",
        "FM": "Mikronesian liittovaltio",
        "FO": "Färsaaret",
        "FR": "Ranska",
        "FX": "Ranskan Eurooppaan kuuluvat osat",
        "GB": "Britannia",
        "GF": "Ranskan Guayana",
        "GL": "Grönlanti",
        "GQ": "Päiväntasaajan Guinea",
        "GR": "Kreikka",
        "GS": "Etelä-Georgia ja Eteläiset Sandwichsaaret",
        "HK": "Hongkong",
        "HM": "Heard- ja McDonaldinsaaret",
        "HR": "Kroatia",
        "HU": "Unkari",
        "IC": "Kanariansaaret",
        "IE": "Irlanti",
        "IM": "Mansaari",
        "IN": "Intia",
        "IO": "Brittiläinen Intian valtameren alue",
        "IQ": "Irak",
        "IS": "Islanti",
        "IT": "Italia",
        "JM": "Jamaika",
        "JO": "Jordania",
        "JP": "Japani",
        "KE": "Kenia",
        "KG": "Kirgisia",
        "KH": "Kambodža",
        "KM": "Komorit",
        "KN": "Saint Kitts ja Nevis",
        "KP": "Pohjois-Korea",
        "KR": "Etelä-Korea",
        "KY": "Caymansaaret",
        "KZ": "Kazakstan",
        "LB": "Libanon",
        "LT": "Liettua",
        "LU": "Luxemburg",
        "MA": "Marokko",
        "MF": "Saint-Martin",
        "MG": "Madagaskar",
        "MH": "Marshallinsaaret",
        "MK": "Makedonia",
        "MM": "Myanmar",
        "MO": "Macao",
        "MP": "Pohjois-Mariaanit",
        "MV": "Malediivit",
        "MX": "Meksiko",
        "MY": "Malesia",
        "MZ": "Mosambik",
        "NC": "Uusi-Kaledonia",
        "NF": "Norfolkinsaari",
        "NL": "Alankomaat",
        "NO": "Norja",
        "NZ": "Uusi-Seelanti",
        "PF": "Ranskan Polynesia",
        "PG": "Papua-Uusi-Guinea",
        "PH": "Filippiinit",
        "PL": "Puola",
        "PM": "Saint-Pierre ja Miquelon",
        "PN": "Pitcairn",
        "PS": "Palestiina",
        "PT": "Portugali",
        "QO": "ulkomeri",
        "RU": "Venäjä",
        "RW": "Ruanda",
        "SA": "Saudi-Arabia",
        "SB": "Salomonsaaret",
        "SC": "Seychellit",
        "SE": "Ruotsi",
        "SJ": "Huippuvuoret ja Jan Mayen",
        "SR": "Surinam",
        "ST": "São Tomé ja Príncipe",
        "SY": "Syyria",
        "SZ": "Swazimaa",
        "TC": "Turks- ja Caicossaaret",
        "TD": "Tšad",
        "TF": "Ranskan ulkopuoliset eteläiset alueet",
        "TH": "Thaimaa",
        "TJ": "Tadžikistan",
        "TL": "Itä-Timor",
        "TR": "Turkki",
        "TT": "Trinidad ja Tobago",
        "TZ": "Tansania",
        "UA": "Ukraina",
        "UM": "Yhdysvaltain pienet erillissaaret",
        "US": "Yhdysvallat",
        "VA": "Vatikaani",
        "VC": "Saint Vincent ja Grenadiinit",
        "VG": "Brittiläiset Neitsytsaaret",
        "VI": "Yhdysvaltain Neitsytsaaret",
        "WF": "Wallis ja Futuna",
        "YE": "Jemen",
        "ZA": "Etelä-Afrikka",
        "ZM": "Sambia",
        "ZZ": "tuntematon tai virheellinen alue"
    };
  }-*/;
}
