/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.gwt.server.impl;

import java.io.IOException;
import java.io.OutputStream;

public class CountOutputStream
extends OutputStream {
    private int count;
    private final OutputStream out;
    private boolean ignoreFlush;

    public CountOutputStream(OutputStream out) {
        this.out = out;
    }

    public int getCount() {
        return this.count;
    }

    public void setIgnoreFlush(boolean ignoreFlush) {
        this.ignoreFlush = ignoreFlush;
    }

    public boolean isIgnoreFlush() {
        return this.ignoreFlush;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.count;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.count += b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.count += len;
    }

    @Override
    public void flush() throws IOException {
        if (!this.ignoreFlush) {
            this.out.flush();
        }
    }
}

