/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.shared.impl.cldr;

// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "cy" locale.
 */
public class DateTimeFormatInfoImpl_cy extends DateTimeFormatInfoImpl {

  @Override
  public String dateFormatFull() {
    return "EEEE, dd MMMM y";
  }

  @Override
  public String dateFormatLong() {
    return "dd MMMM y";
  }

  @Override
  public String dateFormatMedium() {
    return "d MMM y";
  }

  @Override
  public String dateFormatShort() {
    return "dd/MM/yyyy";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "Cyn Crist",
        "Oed Crist"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "CC",
        "OC"
    };
  }

  @Override
  public String formatMonthNumDay() {
    return "d/M";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "Ionawr",
        "Chwefror",
        "Mawrth",
        "Ebrill",
        "Mai",
        "Mehefin",
        "Gorffenaf",
        "Awst",
        "Medi",
        "Hydref",
        "Tachwedd",
        "Rhagfyr"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return new String[] {
        "Ionawr",
        "Chwefror",
        "Mawrth",
        "Ebrill",
        "Mai",
        "Mehefin",
        "Gorffennaf",
        "Awst",
        "Medi",
        "Hydref",
        "Tachwedd",
        "Rhagfyr"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "I",
        "C",
        "M",
        "E",
        "M",
        "M",
        "G",
        "A",
        "M",
        "H",
        "T",
        "R"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "Ion",
        "Chwef",
        "Mawrth",
        "Ebrill",
        "Mai",
        "Meh",
        "Gorff",
        "Awst",
        "Medi",
        "Hyd",
        "Tach",
        "Rhag"
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return new String[] {
        "Ion",
        "Chwe",
        "Maw",
        "Ebr",
        "Mai",
        "Meh",
        "Gor",
        "Awst",
        "Medi",
        "Hyd",
        "Tach",
        "Rhag"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "Chwarter 1af",
        "2il chwarter",
        "3ydd chwarter",
        "4ydd chwarter"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "Ch1",
        "Ch2",
        "Ch3",
        "Ch4"
    };
  }

  @Override
  public String timeFormatFull() {
    return "h:mm:ss a zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "h:mm:ss a z";
  }

  @Override
  public String timeFormatMedium() {
    return "h:mm:ss a";
  }

  @Override
  public String timeFormatShort() {
    return "h:mm a";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "Dydd Sul",
        "Dydd Llun",
        "Dydd Mawrth",
        "Dydd Mercher",
        "Dydd Iau",
        "Dydd Gwener",
        "Dydd Sadwrn"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "S",
        "L",
        "M",
        "M",
        "I",
        "G",
        "S"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "Sul",
        "Llun",
        "Maw",
        "Mer",
        "Iau",
        "Gwen",
        "Sad"
    };
  }

  @Override
  public String[] weekdaysShortStandalone() {
    return new String[] {
        "Sul",
        "Llun",
        "Maw",
        "Mer",
        "Iau",
        "Gwe",
        "Sad"
    };
  }
}
