/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "pl" locale.
 */
public class LocalizedNamesImpl_pl extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "PL",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AL",
        "DZ",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AN",
        "SA",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BY",
        "MM",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "VG",
        "BG",
        "BF",
        "BI",
        "EA",
        "CL",
        "CN",
        "HR",
        "CP",
        "CY",
        "TD",
        "ME",
        "CZ",
        "UM",
        "DK",
        "CD",
        "DG",
        "DM",
        "DJ",
        "EG",
        "EC",
        "ER",
        "EE",
        "ET",
        "FK",
        "FM",
        "FJ",
        "PH",
        "FI",
        "FR",
        "FX",
        "TF",
        "GA",
        "GM",
        "GS",
        "GH",
        "GI",
        "GR",
        "GD",
        "GL",
        "GE",
        "GU",
        "GY",
        "GF",
        "GP",
        "GT",
        "GN",
        "GW",
        "GQ",
        "HT",
        "ES",
        "NL",
        "HN",
        "HK",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "JM",
        "JP",
        "YE",
        "JO",
        "KY",
        "KH",
        "CM",
        "CA",
        "QA",
        "KZ",
        "KE",
        "KG",
        "KI",
        "CO",
        "KM",
        "CG",
        "KR",
        "KP",
        "CR",
        "CU",
        "KW",
        "LA",
        "LS",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "LV",
        "MK",
        "MG",
        "YT",
        "MO",
        "MW",
        "MV",
        "MY",
        "ML",
        "MT",
        "MP",
        "MA",
        "MQ",
        "MR",
        "MU",
        "MX",
        "MD",
        "MC",
        "MN",
        "MS",
        "MZ",
        "NA",
        "NR",
        "NP",
        "DE",
        "NE",
        "NG",
        "NI",
        "NU",
        "NF",
        "NO",
        "NC",
        "NZ",
        "QO",
        "OM",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PF",
        "PL",
        "PR",
        "PT",
        "DO",
        "ZA",
        "CF",
        "CV",
        "RE",
        "RU",
        "RO",
        "RW",
        "EH",
        "BL",
        "KN",
        "LC",
        "PM",
        "VC",
        "SV",
        "WS",
        "AS",
        "SM",
        "SN",
        "RS",
        "CS",
        "SC",
        "SL",
        "SG",
        "MF",
        "SK",
        "SI",
        "SO",
        "LK",
        "US",
        "SZ",
        "SD",
        "SR",
        "SJ",
        "SY",
        "CH",
        "SE",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "PS",
        "IO",
        "TL",
        "TG",
        "TK",
        "TO",
        "TA",
        "TT",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "UG",
        "UA",
        "EU",
        "UY",
        "UZ",
        "VU",
        "WF",
        "VA",
        "VE",
        "HU",
        "GB",
        "VN",
        "IT",
        "CI",
        "BV",
        "CX",
        "GG",
        "JE",
        "IM",
        "SH",
        "AC",
        "AX",
        "CK",
        "VI",
        "HM",
        "IC",
        "CC",
        "MH",
        "FO",
        "SB",
        "ST",
        "ZM",
        "ZW",
        "AE",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Świat");
    namesMap.put("002", "Afryka");
    namesMap.put("003", "Ameryka Północna");
    namesMap.put("005", "Ameryka Południowa");
    namesMap.put("011", "Afryka Zachodnia");
    namesMap.put("013", "Ameryka Środkowa");
    namesMap.put("014", "Afryka Wschodnia");
    namesMap.put("015", "Afryka Północna");
    namesMap.put("017", "Afryka Środkowa");
    namesMap.put("018", "Afryka Południowa");
    namesMap.put("019", "Ameryka");
    namesMap.put("021", "Ameryka Północna - Kanada, USA");
    namesMap.put("029", "Karaiby");
    namesMap.put("030", "Azja Wschodnia");
    namesMap.put("034", "Azja Południowa");
    namesMap.put("035", "Azja Południowo-Wschodnia");
    namesMap.put("039", "Europa Południowa");
    namesMap.put("053", "Australia i Nowa Zelandia");
    namesMap.put("054", "Melanezja");
    namesMap.put("057", "Mikronezja");
    namesMap.put("061", "Polinezja");
    namesMap.put("062", "Azja Południowo-Środkowa");
    namesMap.put("142", "Azja");
    namesMap.put("143", "Azja Środkowa");
    namesMap.put("145", "Azja Zachodnia");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Europa Wschodnia");
    namesMap.put("154", "Europa Północna");
    namesMap.put("155", "Europa Zachodnia");
    namesMap.put("172", "Wspólnota Niezależnych Państw");
    namesMap.put("419", "Ameryka Łacińska i Karaiby");
    namesMap.put("830", "Wyspy Normandzkie");
    namesMap.put("AC", "Wyspa Wniebowstąpienia");
    namesMap.put("AD", "Andora");
    namesMap.put("AE", "Zjednoczone Emiraty Arabskie");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigua i Barbuda");
    namesMap.put("AN", "Antyle Holenderskie");
    namesMap.put("AQ", "Antarktyka");
    namesMap.put("AR", "Argentyna");
    namesMap.put("AS", "Samoa Amerykańskie");
    namesMap.put("AX", "Wyspy Alandzkie");
    namesMap.put("AZ", "Azerbejdżan");
    namesMap.put("BA", "Bośnia i Hercegowina");
    namesMap.put("BD", "Bangladesz");
    namesMap.put("BE", "Belgia");
    namesMap.put("BG", "Bułgaria");
    namesMap.put("BH", "Bahrajn");
    namesMap.put("BM", "Bermudy");
    namesMap.put("BN", "Brunei Darussalam");
    namesMap.put("BO", "Boliwia");
    namesMap.put("BR", "Brazylia");
    namesMap.put("BS", "Bahamy");
    namesMap.put("BV", "Wyspa Bouveta");
    namesMap.put("BY", "Białoruś");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Wyspy Kokosowe");
    namesMap.put("CD", "Demokratyczna Republika Konga");
    namesMap.put("CF", "Republika Środkowoafrykańska");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Szwajcaria");
    namesMap.put("CI", "Wybrzeże Kości Słoniowej");
    namesMap.put("CK", "Wyspy Cooka");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Chiny");
    namesMap.put("CO", "Kolumbia");
    namesMap.put("CP", "Clipperton");
    namesMap.put("CR", "Kostaryka");
    namesMap.put("CS", "Serbia i Czarnogóra");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Republika Zielonego Przylądka");
    namesMap.put("CX", "Wyspa Bożego Narodzenia");
    namesMap.put("CY", "Cypr");
    namesMap.put("CZ", "Czechy");
    namesMap.put("DE", "Niemcy");
    namesMap.put("DJ", "Dżibuti");
    namesMap.put("DK", "Dania");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Republika Dominikańska");
    namesMap.put("DZ", "Algieria");
    namesMap.put("EA", "Ceuta i Melilla");
    namesMap.put("EC", "Ekwador");
    namesMap.put("EG", "Egipt");
    namesMap.put("EH", "Sahara Zachodnia");
    namesMap.put("ER", "Erytrea");
    namesMap.put("ES", "Hiszpania");
    namesMap.put("ET", "Etiopia");
    namesMap.put("EU", "Unia Europejska");
    namesMap.put("FI", "Finlandia");
    namesMap.put("FJ", "Fidżi");
    namesMap.put("FK", "Falklandy");
    namesMap.put("FM", "Federalne Stany Mikronezji");
    namesMap.put("FO", "Wyspy Owcze");
    namesMap.put("FR", "Francja");
    namesMap.put("FX", "Francja metropolitalna");
    namesMap.put("GB", "Wielka Brytania");
    namesMap.put("GE", "Gruzja");
    namesMap.put("GF", "Gujana Francuska");
    namesMap.put("GG", "Wyspa Guernsey");
    namesMap.put("GL", "Grenlandia");
    namesMap.put("GN", "Gwinea");
    namesMap.put("GP", "Gwadelupa");
    namesMap.put("GQ", "Gwinea Równikowa");
    namesMap.put("GR", "Grecja");
    namesMap.put("GS", "Georgia Południowa i Sandwich Południowy");
    namesMap.put("GT", "Gwatemala");
    namesMap.put("GW", "Gwinea Bissau");
    namesMap.put("GY", "Gujana");
    namesMap.put("HK", "Hongkong");
    namesMap.put("HM", "Wyspy Heard i McDonalda");
    namesMap.put("HR", "Chorwacja");
    namesMap.put("HU", "Węgry");
    namesMap.put("IC", "Wyspy Kanaryjskie");
    namesMap.put("ID", "Indonezja");
    namesMap.put("IE", "Irlandia");
    namesMap.put("IL", "Izrael");
    namesMap.put("IM", "Wyspa Man");
    namesMap.put("IN", "Indie");
    namesMap.put("IO", "Terytorium Brytyjskie Oceanu Indyjskiego");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Islandia");
    namesMap.put("IT", "Włochy");
    namesMap.put("JE", "Wyspa Jersey");
    namesMap.put("JM", "Jamajka");
    namesMap.put("JO", "Jordania");
    namesMap.put("JP", "Japonia");
    namesMap.put("KE", "Kenia");
    namesMap.put("KG", "Kirgistan");
    namesMap.put("KH", "Kambodża");
    namesMap.put("KM", "Komory");
    namesMap.put("KN", "Saint Kitts i Nevis");
    namesMap.put("KP", "Korea Północna");
    namesMap.put("KR", "Korea Południowa");
    namesMap.put("KW", "Kuwejt");
    namesMap.put("KY", "Kajmany");
    namesMap.put("KZ", "Kazachstan");
    namesMap.put("LB", "Liban");
    namesMap.put("LT", "Litwa");
    namesMap.put("LU", "Luksemburg");
    namesMap.put("LV", "Łotwa");
    namesMap.put("LY", "Libia");
    namesMap.put("MA", "Maroko");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Mołdawia");
    namesMap.put("ME", "Czarnogóra");
    namesMap.put("MF", "Sint Maarten");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Wyspy Marshalla");
    namesMap.put("MK", "Macedonia");
    namesMap.put("MM", "Birma");
    namesMap.put("MO", "Makau");
    namesMap.put("MP", "Mariany Północne");
    namesMap.put("MQ", "Martynika");
    namesMap.put("MR", "Mauretania");
    namesMap.put("MV", "Malediwy");
    namesMap.put("MX", "Meksyk");
    namesMap.put("MY", "Malezja");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NC", "Nowa Kaledonia");
    namesMap.put("NF", "Norfolk");
    namesMap.put("NI", "Nikaragua");
    namesMap.put("NL", "Holandia");
    namesMap.put("NO", "Norwegia");
    namesMap.put("NZ", "Nowa Zelandia");
    namesMap.put("PF", "Polinezja Francuska");
    namesMap.put("PG", "Papua Nowa Gwinea");
    namesMap.put("PH", "Filipiny");
    namesMap.put("PL", "Polska");
    namesMap.put("PM", "Saint-Pierre i Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PR", "Portoryko");
    namesMap.put("PS", "Terytoria Palestyńskie");
    namesMap.put("PT", "Portugalia");
    namesMap.put("PY", "Paragwaj");
    namesMap.put("QA", "Katar");
    namesMap.put("QO", "Oceania inne");
    namesMap.put("RE", "Reunion");
    namesMap.put("RO", "Rumunia");
    namesMap.put("RU", "Rosja");
    namesMap.put("SA", "Arabia Saudyjska");
    namesMap.put("SB", "Wyspy Salomona");
    namesMap.put("SC", "Seszele");
    namesMap.put("SE", "Szwecja");
    namesMap.put("SG", "Singapur");
    namesMap.put("SH", "Wyspa Świętej Heleny");
    namesMap.put("SI", "Słowenia");
    namesMap.put("SJ", "Svalbard i Jan Mayen");
    namesMap.put("SK", "Słowacja");
    namesMap.put("SR", "Surinam");
    namesMap.put("ST", "Wyspy Świętego Tomasza i Książęca");
    namesMap.put("SV", "Salwador");
    namesMap.put("SZ", "Suazi");
    namesMap.put("TC", "Turks i Caicos");
    namesMap.put("TD", "Czad");
    namesMap.put("TF", "Francuskie Terytoria Południowe");
    namesMap.put("TH", "Tajlandia");
    namesMap.put("TJ", "Tadżykistan");
    namesMap.put("TL", "Timor Wschodni");
    namesMap.put("TN", "Tunezja");
    namesMap.put("TR", "Turcja");
    namesMap.put("TT", "Trynidad i Tobago");
    namesMap.put("TW", "Tajwan");
    namesMap.put("UA", "Ukraina");
    namesMap.put("UM", "Dalekie Wyspy Mniejsze Stanów Zjednoczonych");
    namesMap.put("US", "Stany Zjednoczone");
    namesMap.put("UY", "Urugwaj");
    namesMap.put("VA", "Watykan");
    namesMap.put("VC", "Saint Vincent i Grenadyny");
    namesMap.put("VE", "Wenezuela");
    namesMap.put("VG", "Brytyjskie Wyspy Dziewicze");
    namesMap.put("VI", "Wyspy Dziewicze Stanów Zjednoczonych");
    namesMap.put("VN", "Wietnam");
    namesMap.put("WF", "Wallis i Futuna");
    namesMap.put("YE", "Jemen");
    namesMap.put("YT", "Majotta");
    namesMap.put("ZA", "Republika Południowej Afryki");
    namesMap.put("ZZ", "Nieznany lub nieprawidłowy region");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Świat",
        "002": "Afryka",
        "003": "Ameryka Północna",
        "005": "Ameryka Południowa",
        "011": "Afryka Zachodnia",
        "013": "Ameryka Środkowa",
        "014": "Afryka Wschodnia",
        "015": "Afryka Północna",
        "017": "Afryka Środkowa",
        "018": "Afryka Południowa",
        "019": "Ameryka",
        "021": "Ameryka Północna - Kanada, USA",
        "029": "Karaiby",
        "030": "Azja Wschodnia",
        "034": "Azja Południowa",
        "035": "Azja Południowo-Wschodnia",
        "039": "Europa Południowa",
        "053": "Australia i Nowa Zelandia",
        "054": "Melanezja",
        "057": "Mikronezja",
        "061": "Polinezja",
        "062": "Azja Południowo-Środkowa",
        "142": "Azja",
        "143": "Azja Środkowa",
        "145": "Azja Zachodnia",
        "150": "Europa",
        "151": "Europa Wschodnia",
        "154": "Europa Północna",
        "155": "Europa Zachodnia",
        "172": "Wspólnota Niezależnych Państw",
        "419": "Ameryka Łacińska i Karaiby",
        "830": "Wyspy Normandzkie",
        "AC": "Wyspa Wniebowstąpienia",
        "AD": "Andora",
        "AE": "Zjednoczone Emiraty Arabskie",
        "AF": "Afganistan",
        "AG": "Antigua i Barbuda",
        "AN": "Antyle Holenderskie",
        "AQ": "Antarktyka",
        "AR": "Argentyna",
        "AS": "Samoa Amerykańskie",
        "AX": "Wyspy Alandzkie",
        "AZ": "Azerbejdżan",
        "BA": "Bośnia i Hercegowina",
        "BD": "Bangladesz",
        "BE": "Belgia",
        "BG": "Bułgaria",
        "BH": "Bahrajn",
        "BM": "Bermudy",
        "BN": "Brunei Darussalam",
        "BO": "Boliwia",
        "BR": "Brazylia",
        "BS": "Bahamy",
        "BV": "Wyspa Bouveta",
        "BY": "Białoruś",
        "CA": "Kanada",
        "CC": "Wyspy Kokosowe",
        "CD": "Demokratyczna Republika Konga",
        "CF": "Republika Środkowoafrykańska",
        "CG": "Kongo",
        "CH": "Szwajcaria",
        "CI": "Wybrzeże Kości Słoniowej",
        "CK": "Wyspy Cooka",
        "CM": "Kamerun",
        "CN": "Chiny",
        "CO": "Kolumbia",
        "CP": "Clipperton",
        "CR": "Kostaryka",
        "CS": "Serbia i Czarnogóra",
        "CU": "Kuba",
        "CV": "Republika Zielonego Przylądka",
        "CX": "Wyspa Bożego Narodzenia",
        "CY": "Cypr",
        "CZ": "Czechy",
        "DE": "Niemcy",
        "DJ": "Dżibuti",
        "DK": "Dania",
        "DM": "Dominika",
        "DO": "Republika Dominikańska",
        "DZ": "Algieria",
        "EA": "Ceuta i Melilla",
        "EC": "Ekwador",
        "EG": "Egipt",
        "EH": "Sahara Zachodnia",
        "ER": "Erytrea",
        "ES": "Hiszpania",
        "ET": "Etiopia",
        "EU": "Unia Europejska",
        "FI": "Finlandia",
        "FJ": "Fidżi",
        "FK": "Falklandy",
        "FM": "Federalne Stany Mikronezji",
        "FO": "Wyspy Owcze",
        "FR": "Francja",
        "FX": "Francja metropolitalna",
        "GB": "Wielka Brytania",
        "GE": "Gruzja",
        "GF": "Gujana Francuska",
        "GG": "Wyspa Guernsey",
        "GL": "Grenlandia",
        "GN": "Gwinea",
        "GP": "Gwadelupa",
        "GQ": "Gwinea Równikowa",
        "GR": "Grecja",
        "GS": "Georgia Południowa i Sandwich Południowy",
        "GT": "Gwatemala",
        "GW": "Gwinea Bissau",
        "GY": "Gujana",
        "HK": "Hongkong",
        "HM": "Wyspy Heard i McDonalda",
        "HR": "Chorwacja",
        "HU": "Węgry",
        "IC": "Wyspy Kanaryjskie",
        "ID": "Indonezja",
        "IE": "Irlandia",
        "IL": "Izrael",
        "IM": "Wyspa Man",
        "IN": "Indie",
        "IO": "Terytorium Brytyjskie Oceanu Indyjskiego",
        "IQ": "Irak",
        "IS": "Islandia",
        "IT": "Włochy",
        "JE": "Wyspa Jersey",
        "JM": "Jamajka",
        "JO": "Jordania",
        "JP": "Japonia",
        "KE": "Kenia",
        "KG": "Kirgistan",
        "KH": "Kambodża",
        "KM": "Komory",
        "KN": "Saint Kitts i Nevis",
        "KP": "Korea Północna",
        "KR": "Korea Południowa",
        "KW": "Kuwejt",
        "KY": "Kajmany",
        "KZ": "Kazachstan",
        "LB": "Liban",
        "LT": "Litwa",
        "LU": "Luksemburg",
        "LV": "Łotwa",
        "LY": "Libia",
        "MA": "Maroko",
        "MC": "Monako",
        "MD": "Mołdawia",
        "ME": "Czarnogóra",
        "MF": "Sint Maarten",
        "MG": "Madagaskar",
        "MH": "Wyspy Marshalla",
        "MK": "Macedonia",
        "MM": "Birma",
        "MO": "Makau",
        "MP": "Mariany Północne",
        "MQ": "Martynika",
        "MR": "Mauretania",
        "MV": "Malediwy",
        "MX": "Meksyk",
        "MY": "Malezja",
        "MZ": "Mozambik",
        "NC": "Nowa Kaledonia",
        "NF": "Norfolk",
        "NI": "Nikaragua",
        "NL": "Holandia",
        "NO": "Norwegia",
        "NZ": "Nowa Zelandia",
        "PF": "Polinezja Francuska",
        "PG": "Papua Nowa Gwinea",
        "PH": "Filipiny",
        "PL": "Polska",
        "PM": "Saint-Pierre i Miquelon",
        "PN": "Pitcairn",
        "PR": "Portoryko",
        "PS": "Terytoria Palestyńskie",
        "PT": "Portugalia",
        "PY": "Paragwaj",
        "QA": "Katar",
        "QO": "Oceania inne",
        "RE": "Reunion",
        "RO": "Rumunia",
        "RU": "Rosja",
        "SA": "Arabia Saudyjska",
        "SB": "Wyspy Salomona",
        "SC": "Seszele",
        "SE": "Szwecja",
        "SG": "Singapur",
        "SH": "Wyspa Świętej Heleny",
        "SI": "Słowenia",
        "SJ": "Svalbard i Jan Mayen",
        "SK": "Słowacja",
        "SR": "Surinam",
        "ST": "Wyspy Świętego Tomasza i Książęca",
        "SV": "Salwador",
        "SZ": "Suazi",
        "TC": "Turks i Caicos",
        "TD": "Czad",
        "TF": "Francuskie Terytoria Południowe",
        "TH": "Tajlandia",
        "TJ": "Tadżykistan",
        "TL": "Timor Wschodni",
        "TN": "Tunezja",
        "TR": "Turcja",
        "TT": "Trynidad i Tobago",
        "TW": "Tajwan",
        "UA": "Ukraina",
        "UM": "Dalekie Wyspy Mniejsze Stanów Zjednoczonych",
        "US": "Stany Zjednoczone",
        "UY": "Urugwaj",
        "VA": "Watykan",
        "VC": "Saint Vincent i Grenadyny",
        "VE": "Wenezuela",
        "VG": "Brytyjskie Wyspy Dziewicze",
        "VI": "Wyspy Dziewicze Stanów Zjednoczonych",
        "VN": "Wietnam",
        "WF": "Wallis i Futuna",
        "YE": "Jemen",
        "YT": "Majotta",
        "ZA": "Republika Południowej Afryki",
        "ZZ": "Nieznany lub nieprawidłowy region"
    };
  }-*/;
}
