/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container.version;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.container.version.Jetty8WebSocket;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketResponseFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Grizzly2WebSocket
extends WebSocket {
    private static final Logger logger = LoggerFactory.getLogger(Jetty8WebSocket.class);
    private final org.glassfish.grizzly.websockets.WebSocket webSocket;
    private final AtomicBoolean firstWrite = new AtomicBoolean(false);

    public Grizzly2WebSocket(org.glassfish.grizzly.websockets.WebSocket webSocket, AtmosphereConfig config) {
        super(config);
        this.webSocket = webSocket;
    }

    @Override
    public WebSocket writeError(AtmosphereResponse r, int errorCode, String message) throws IOException {
        if (!this.firstWrite.get()) {
            logger.debug("The WebSocket handshake succeeded but the dispatched URI failed {}:{}. The WebSocket connection is still open and client can continue sending messages.", (Object)message, (Object)errorCode);
        } else {
            logger.debug("{} {}", (Object)errorCode, (Object)message);
        }
        return this;
    }

    @Override
    public WebSocket redirect(AtmosphereResponse r, String location) throws IOException {
        logger.error("redirect not supported");
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, String data) throws IOException {
        if (this.binaryWrite) {
            byte[] b = this.webSocketResponseFilter.filter(r, data).getBytes(this.resource().getResponse().getCharacterEncoding());
            if (b != null) {
                this.webSocket.send(b);
            }
        } else {
            String s = this.webSocketResponseFilter.filter(r, data);
            if (s != null) {
                this.webSocket.send(s);
            }
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, byte[] data) throws IOException {
        if (this.binaryWrite) {
            byte[] b = this.webSocketResponseFilter.filter(r, data);
            if (b != null) {
                this.webSocket.send(b);
            }
        } else {
            String s = this.webSocketResponseFilter.filter(r, new String(data));
            if (s != null) {
                this.webSocket.send(s);
            }
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, byte[] data, int offset, int length) throws IOException {
        if (this.binaryWrite) {
            if (!WebSocketResponseFilter.NoOpsWebSocketResponseFilter.class.isAssignableFrom(this.webSocketResponseFilter.getClass())) {
                byte[] b = this.webSocketResponseFilter.filter(r, data, offset, length);
                if (b != null) {
                    this.webSocket.send(b);
                }
            } else {
                this.webSocket.send(Arrays.copyOfRange(data, offset, length));
            }
        } else {
            String s = this.webSocketResponseFilter.filter(r, new String(data, offset, length));
            if (s != null) {
                this.webSocket.send(s);
            }
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public void close(AtmosphereResponse r) throws IOException {
        this.webSocket.close();
    }

    @Override
    public WebSocket flush(AtmosphereResponse r) throws IOException {
        return this;
    }
}

