/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "te" locale.
 */
public class LocalizedNamesImpl_te extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AO",
        "AQ",
        "AZ",
        "AD",
        "AS",
        "AW",
        "DZ",
        "AL",
        "AI",
        "AG",
        "AF",
        "AR",
        "AM",
        "AX",
        "AT",
        "AU",
        "ID",
        "IT",
        "ET",
        "IQ",
        "IR",
        "IL",
        "EC",
        "EG",
        "UZ",
        "KP",
        "MP",
        "UY",
        "GQ",
        "ER",
        "SV",
        "AC",
        "EE",
        "IE",
        "IM",
        "CI",
        "IS",
        "OM",
        "QO",
        "KH",
        "KZ",
        "QA",
        "CD",
        "CG",
        "KI",
        "KG",
        "CK",
        "KW",
        "CA",
        "KE",
        "CM",
        "IC",
        "CV",
        "KY",
        "KM",
        "CO",
        "CC",
        "CR",
        "CU",
        "CX",
        "NC",
        "HR",
        "CP",
        "GY",
        "GM",
        "GN",
        "GW",
        "GA",
        "GL",
        "GR",
        "GD",
        "GT",
        "GP",
        "GU",
        "GG",
        "GH",
        "DE",
        "TD",
        "CL",
        "CZ",
        "CN",
        "JP",
        "JM",
        "JE",
        "ZM",
        "GE",
        "JO",
        "ZW",
        "DJ",
        "GI",
        "TR",
        "TZ",
        "TJ",
        "TL",
        "TV",
        "TW",
        "TO",
        "TK",
        "TG",
        "TN",
        "TT",
        "TA",
        "DG",
        "DK",
        "DO",
        "DM",
        "TM",
        "TC",
        "TH",
        "ZA",
        "KR",
        "GS",
        "NA",
        "NO",
        "NF",
        "NI",
        "NU",
        "NL",
        "AN",
        "NP",
        "NE",
        "NG",
        "NR",
        "NZ",
        "EH",
        "PA",
        "PW",
        "PK",
        "PG",
        "PS",
        "PN",
        "PY",
        "PE",
        "PR",
        "PT",
        "PL",
        "FK",
        "FO",
        "FJ",
        "FI",
        "PH",
        "FR",
        "GF",
        "TF",
        "PF",
        "BM",
        "BG",
        "BH",
        "BS",
        "BD",
        "BB",
        "BA",
        "BI",
        "BF",
        "BJ",
        "BY",
        "BZ",
        "BE",
        "BO",
        "BV",
        "BW",
        "BR",
        "GB",
        "IO",
        "VG",
        "BN",
        "IN",
        "BT",
        "MN",
        "CF",
        "MY",
        "MO",
        "MG",
        "YT",
        "MU",
        "MQ",
        "MH",
        "MW",
        "ML",
        "MT",
        "MV",
        "MX",
        "MK",
        "FM",
        "MZ",
        "MC",
        "MA",
        "ME",
        "MS",
        "MD",
        "MR",
        "MM",
        "VI",
        "UA",
        "UG",
        "AE",
        "EU",
        "YE",
        "RU",
        "RE",
        "RO",
        "RW",
        "LU",
        "LV",
        "LA",
        "LI",
        "LT",
        "LY",
        "LB",
        "LS",
        "LR",
        "VU",
        "WF",
        "VN",
        "VE",
        "VA",
        "LK",
        "US",
        "UM",
        "WS",
        "CS",
        "SM",
        "ST",
        "SG",
        "SL",
        "SY",
        "SC",
        "SD",
        "SR",
        "KN",
        "PM",
        "BL",
        "MF",
        "LC",
        "VC",
        "SH",
        "SN",
        "RS",
        "CY",
        "SO",
        "SB",
        "SA",
        "ES",
        "EA",
        "SK",
        "SI",
        "SZ",
        "SJ",
        "CH",
        "SE",
        "HU",
        "HK",
        "HM",
        "HT",
        "HN",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "ప్రపంచం");
    namesMap.put("002", "ఆఫ్రికా");
    namesMap.put("003", "ఉత్తర అమెరికా ఖండము");
    namesMap.put("005", "దక్షిణ అమెరికా");
    namesMap.put("009", "ఒషేనియ");
    namesMap.put("011", "పడమటి ఆఫ్రికా");
    namesMap.put("013", "మధ్యమ అమెరికా");
    namesMap.put("014", "తూర్పు ఆఫ్రికా");
    namesMap.put("015", "ఉత్తర ఆఫ్రికా");
    namesMap.put("017", "మధ్యమ ఆఫ్రికా");
    namesMap.put("018", "దక్షిణ ఆఫ్రికా");
    namesMap.put("019", "అమెరికాలు");
    namesMap.put("021", "ఉత్తర అమెరికా");
    namesMap.put("029", "కరిబ్బియన్");
    namesMap.put("030", "తూర్పు ఆశియా");
    namesMap.put("034", "దక్షిణ ఆశియా");
    namesMap.put("035", "నైరుతి ఆశియా");
    namesMap.put("039", "దక్షిణ ఐరోపా");
    namesMap.put("053", "ఆస్ట్రేలియా మరియు న్యూజిలాండ్");
    namesMap.put("054", "మెలనేశియ");
    namesMap.put("057", "మైక్రోనేశియ ప్రాంతం");
    namesMap.put("061", "పాలినేషియా");
    namesMap.put("062", "దక్షిణ మధ్యమ ఆశియా");
    namesMap.put("142", "ఆశియా");
    namesMap.put("143", "మధ్యమ ఆశియా");
    namesMap.put("145", "పడమటి ఆశియా");
    namesMap.put("150", "ఐరోపా");
    namesMap.put("151", "తూర్పు ఐరోపా");
    namesMap.put("154", "ఉత్తర ఐరోపా");
    namesMap.put("155", "పడమటి ఐరోపా");
    namesMap.put("172", "స్వతంత్ర రాష్ట్రాల కామన్ వెల్త్");
    namesMap.put("200", "చెకస్లొవేకియ");
    namesMap.put("419", "లాటిన్ అమెరికా మరియు కేరబ్బియన్");
    namesMap.put("830", "చానెల్ దీవులు");
    namesMap.put("AC", "ఎసెషన్ దీవి");
    namesMap.put("AD", "అన్డోరా");
    namesMap.put("AE", "యునైటెడ్ ఆరబ్ ఎమిరేట్స్");
    namesMap.put("AF", "ఆఫ్ఘానిస్తాన్");
    namesMap.put("AG", "ఆంటిగ్వా మరియు బార్బుడా");
    namesMap.put("AI", "ఆంగవిల్లా");
    namesMap.put("AL", "అల్బేనియా");
    namesMap.put("AM", "ఆర్మేనియా");
    namesMap.put("AN", "నేదేర్లేండ్స్ అంటిల్లిస్");
    namesMap.put("AO", "అంగోలా");
    namesMap.put("AQ", "అంటార్కటికా");
    namesMap.put("AR", "ఆర్జెంటినా");
    namesMap.put("AS", "అమెరికన్ సమోవా");
    namesMap.put("AT", "ఆస్ట్రియా");
    namesMap.put("AU", "ఆస్ట్రేలియా");
    namesMap.put("AW", "అరుబా");
    namesMap.put("AX", "ఆలేండ్ దీవులు");
    namesMap.put("AZ", "అజర్బైజాన్");
    namesMap.put("BA", "బాస్నియా మరియు హీర్జిగోవినా");
    namesMap.put("BB", "బార్బడోస్");
    namesMap.put("BD", "బాంగ్లాదేష్");
    namesMap.put("BE", "బెల్జియం");
    namesMap.put("BF", "బుర్కినా ఫాసో");
    namesMap.put("BG", "బల్గేరియా");
    namesMap.put("BH", "బహరేన్");
    namesMap.put("BI", "బురుండి");
    namesMap.put("BJ", "బెనిన్");
    namesMap.put("BL", "సెంట్ బర్తేలెమీ");
    namesMap.put("BM", "బర్మయుడా");
    namesMap.put("BN", "బ్రునై");
    namesMap.put("BO", "బొలీవియా");
    namesMap.put("BR", "బ్రజిల్");
    namesMap.put("BS", "బహామాస్");
    namesMap.put("BT", "భూటాన్");
    namesMap.put("BV", "బొవెట్ దీవి");
    namesMap.put("BW", "బోట్స్వానా");
    namesMap.put("BY", "బెలారస్");
    namesMap.put("BZ", "బెలీజ్");
    namesMap.put("CA", "కెనడా");
    namesMap.put("CC", "కోకోస్ దీవులు");
    namesMap.put("CD", "కాంగో- కిన్షాసా");
    namesMap.put("CF", "మధ్యమ ఆఫ్రికా రిపబ్లిక్");
    namesMap.put("CG", "కాంగో- బ్రాజావిల్లి");
    namesMap.put("CH", "స్విట్జర్లేండ్");
    namesMap.put("CI", "ఐవరీ కోస్ట్");
    namesMap.put("CK", "కుక్ దీవులు");
    namesMap.put("CL", "చిలి");
    namesMap.put("CM", "కెమరూన్");
    namesMap.put("CN", "చైనా");
    namesMap.put("CO", "కొలంబియా");
    namesMap.put("CP", "క్లిప్పర్టన్ దీవి");
    namesMap.put("CR", "కోస్టారికా");
    namesMap.put("CS", "సర్బియా మరియు మంటెనీగ్రో");
    namesMap.put("CU", "క్యూబా");
    namesMap.put("CV", "కేప్ వెర్డే");
    namesMap.put("CX", "క్రిస్మస్ దీవి");
    namesMap.put("CY", "సైప్రస్");
    namesMap.put("CZ", "చెక్ గణరాజ్యం");
    namesMap.put("DE", "ఙర్మని");
    namesMap.put("DG", "డియాగో గార్సియా");
    namesMap.put("DJ", "జిబౌటి");
    namesMap.put("DK", "డెన్మార్క్");
    namesMap.put("DM", "డోమెనిక");
    namesMap.put("DO", "డొమినికన్ గణ రాజ్యం");
    namesMap.put("DZ", "అల్జీరియా");
    namesMap.put("EA", "స్యూటా మరియు మెలిల్లా");
    namesMap.put("EC", "ఈక్వడోర్");
    namesMap.put("EE", "ఎస్టోనియా");
    namesMap.put("EG", "ఈజిప్ట్");
    namesMap.put("EH", "పడమటి సహారా");
    namesMap.put("ER", "ఎరిట్రియా");
    namesMap.put("ES", "స్పేన్");
    namesMap.put("ET", "ఇథియోపియా");
    namesMap.put("EU", "యురోపియన్ యునియన్");
    namesMap.put("FI", "ఫిన్లాండ్");
    namesMap.put("FJ", "ఫిజి");
    namesMap.put("FK", "ఫాక్ లేండ్ దీవులు");
    namesMap.put("FM", "మైక్రోనేశియ");
    namesMap.put("FO", "ఫారో దీవులు");
    namesMap.put("FR", "ఫ్రాన్స్‌");
    namesMap.put("GA", "గేబన్");
    namesMap.put("GB", "బ్రిటన్");
    namesMap.put("GD", "గ్రెనెడా");
    namesMap.put("GE", "జార్జియా");
    namesMap.put("GF", "ఫ్రెంచ్ గియానా");
    namesMap.put("GG", "గ్వేర్నసే");
    namesMap.put("GH", "ఘానా");
    namesMap.put("GI", "జిబ్రాల్టార్");
    namesMap.put("GL", "గ్రీన్లేండ్");
    namesMap.put("GM", "గాంబియా");
    namesMap.put("GN", "గినియా");
    namesMap.put("GP", "గ్వాడేలోప్");
    namesMap.put("GQ", "ఎక్వేటోరియాల్ గినియా");
    namesMap.put("GR", "గ్రీస్");
    namesMap.put("GS", "దక్షిణ జార్జియా మరియు దక్షిణ సాండ్విచ్ దీవులు");
    namesMap.put("GT", "గ్వాటిమాల");
    namesMap.put("GU", "గ్వామ్");
    namesMap.put("GW", "గినియా-బిస్సావ్");
    namesMap.put("GY", "గయానా");
    namesMap.put("HK", "హాంగ్ కాంగ్");
    namesMap.put("HM", "హెర్డ్ దీవి మరియు మాక్ డోనాల్డ్ దీవులు");
    namesMap.put("HN", "హోండోరాస్");
    namesMap.put("HR", "క్రోయేషియా");
    namesMap.put("HT", "హైటి");
    namesMap.put("HU", "హన్గేరి");
    namesMap.put("IC", "కేనరీ దీవులు");
    namesMap.put("ID", "ఇండోనేషియా");
    namesMap.put("IE", "ఐర్ లాండ్");
    namesMap.put("IL", "ఇస్రాయేల్");
    namesMap.put("IM", "ఐల్ ఆఫ్ మాన్");
    namesMap.put("IN", "భారత దేశం");
    namesMap.put("IO", "బ్రిటిష్ భారతీయ ఓషన్ ప్రాంతం");
    namesMap.put("IQ", "ఇరాక్");
    namesMap.put("IR", "ఇరాన్");
    namesMap.put("IS", "ఐస్లాండ్");
    namesMap.put("IT", "ఇటలి");
    namesMap.put("JE", "జర్సి");
    namesMap.put("JM", "జమైకా");
    namesMap.put("JO", "జార్డాన్");
    namesMap.put("JP", "జపాన్");
    namesMap.put("KE", "కెన్యా");
    namesMap.put("KG", "కిర్జిస్తాన్");
    namesMap.put("KH", "కంబోడియా");
    namesMap.put("KI", "కిరిబాటి");
    namesMap.put("KM", "కొమొరోస్");
    namesMap.put("KN", "సెంట్ కిట్ట్స్ మరియు నెవిస్");
    namesMap.put("KP", "ఉత్తర కొరియా");
    namesMap.put("KR", "దక్షిణ కొరియా");
    namesMap.put("KW", "కువైట్");
    namesMap.put("KY", "కేమాన్ దీవులు");
    namesMap.put("KZ", "కజాఖస్తాన్");
    namesMap.put("LA", "లావోస్");
    namesMap.put("LB", "లెబనాన్");
    namesMap.put("LC", "సెంట్ లూసియా");
    namesMap.put("LI", "లిక్టెస్టేన్");
    namesMap.put("LK", "శ్రీలంక");
    namesMap.put("LR", "లైబీరియా");
    namesMap.put("LS", "లెసోతో");
    namesMap.put("LT", "లిథుయేనియా");
    namesMap.put("LU", "లక్సంబర్గ్");
    namesMap.put("LV", "లాట్వియ");
    namesMap.put("LY", "లిబియా");
    namesMap.put("MA", "మొరాక్కో");
    namesMap.put("MC", "మొనాకో");
    namesMap.put("MD", "మోల్ డోవ");
    namesMap.put("ME", "మోంటేనేగ్రో");
    namesMap.put("MF", "సెంట్ మార్టిన్");
    namesMap.put("MG", "మాడ్గాస్కార్");
    namesMap.put("MH", "మార్షల్ దీవులు");
    namesMap.put("MK", "మేసెడోనియా");
    namesMap.put("ML", "మాలి");
    namesMap.put("MM", "మ్యాన్మార్");
    namesMap.put("MN", "మంగోలియా");
    namesMap.put("MO", "మాకావ్");
    namesMap.put("MP", "ఉత్తర మరియానా దీవులు");
    namesMap.put("MQ", "మార్టినిక్");
    namesMap.put("MR", "మౌరిటేనియా");
    namesMap.put("MS", "మోంట్సేర్రాట్");
    namesMap.put("MT", "మాల్టా");
    namesMap.put("MU", "మారిషస్");
    namesMap.put("MV", "మాల్దీవులు");
    namesMap.put("MW", "మాలావి");
    namesMap.put("MX", "మెక్సికో");
    namesMap.put("MY", "మలేషియా");
    namesMap.put("MZ", "మొజాంబిక్");
    namesMap.put("NA", "నమీబియా");
    namesMap.put("NC", "క్రొత్త కాలెడోనియా");
    namesMap.put("NE", "నైజర్");
    namesMap.put("NF", "నార్ఫాక్ దీవి");
    namesMap.put("NG", "నైజీరియా");
    namesMap.put("NI", "నికరాగువా");
    namesMap.put("NL", "నేదర్లాండ్స్");
    namesMap.put("NO", "నారవే");
    namesMap.put("NP", "నేపాల్");
    namesMap.put("NR", "నౌరు");
    namesMap.put("NU", "నియు");
    namesMap.put("NZ", "న్యుజిలేండ్");
    namesMap.put("OM", "ఒమాన్");
    namesMap.put("PA", "పనామా");
    namesMap.put("PE", "పెరూ");
    namesMap.put("PF", "ఫ్రెంచ్ పోలినిషియా");
    namesMap.put("PG", "పాపువా న్యు గినియా");
    namesMap.put("PH", "ఫిలి పైన్స్");
    namesMap.put("PK", "పాకిస్తాన్");
    namesMap.put("PL", "పోలాండ్");
    namesMap.put("PM", "సెంట్ పియెర్ మరియు మికెలాన్");
    namesMap.put("PN", "పిట్కెర్న్");
    namesMap.put("PR", "పోటోరికో");
    namesMap.put("PS", "పాలిస్తినియాన్ ప్రాంతం");
    namesMap.put("PT", "పోర్చుగల్");
    namesMap.put("PW", "పలావు");
    namesMap.put("PY", "పెరగువే");
    namesMap.put("QA", "కతర్");
    namesMap.put("QO", "ఒషేనియా బయటున్నవి");
    namesMap.put("RE", "రియూనియన్");
    namesMap.put("RO", "రోమానియా");
    namesMap.put("RS", "సెర్బియా");
    namesMap.put("RU", "రష్య");
    namesMap.put("RW", "ర్వాండా");
    namesMap.put("SA", "సౌదీ అరేబియా");
    namesMap.put("SB", "సోలోమన్ దీవులు");
    namesMap.put("SC", "సీషెల్స్");
    namesMap.put("SD", "సుడాన్");
    namesMap.put("SE", "స్వీడన్");
    namesMap.put("SG", "సింగపూర్");
    namesMap.put("SH", "సెంట్ హెలినా");
    namesMap.put("SI", "స్లోవేనియా");
    namesMap.put("SJ", "స్వాల్బార్డ్ మరియు యాన్ మాయేన్");
    namesMap.put("SK", "స్లోవేకియా");
    namesMap.put("SL", "సియెర్రా లియాన్");
    namesMap.put("SM", "సాన్ మారినో");
    namesMap.put("SN", "సెనెగల్");
    namesMap.put("SO", "సోమాలియా");
    namesMap.put("SR", "సురినామ్");
    namesMap.put("ST", "సావోటోమ్ మరియు ప్రిన్సిపే");
    namesMap.put("SV", "ఎల్ సాల్వడోర్");
    namesMap.put("SY", "సిరియా");
    namesMap.put("SZ", "స్వాజీలేండ్");
    namesMap.put("TA", "ట్రిస్టన్ డ కన్హా");
    namesMap.put("TC", "తుర్క్ మరియు కాలికోస్ దీవులు");
    namesMap.put("TD", "చాద్");
    namesMap.put("TF", "ఫ్రెంచ్ దక్షిణ ప్రాంతాలు");
    namesMap.put("TG", "టోగో");
    namesMap.put("TH", "థాయ్ లాండ్");
    namesMap.put("TJ", "టాజీకిస్తాన్");
    namesMap.put("TK", "టోకేలావ్");
    namesMap.put("TL", "టిమోర్-లెస్టె");
    namesMap.put("TM", "తుర్కమెస్తాన్");
    namesMap.put("TN", "ట్యునీషియా");
    namesMap.put("TO", "టోంగా");
    namesMap.put("TR", "టర్కీ");
    namesMap.put("TT", "ట్రినిడేడ్ మరియు టొబాగో");
    namesMap.put("TV", "టువాలు");
    namesMap.put("TW", "టైవాన్");
    namesMap.put("TZ", "టాంజానియా");
    namesMap.put("UA", "యుక్రెన్");
    namesMap.put("UG", "యుగాండా");
    namesMap.put("UM", "సంయుక్త రాజ్య అమెరికా యునైటెడ్ స్టేట్స్ మైనర్ బయట ఉన్న దీవులు");
    namesMap.put("US", "సంయుక్త రాజ్య అమెరికా");
    namesMap.put("UY", "ఉరుగువే");
    namesMap.put("UZ", "ఉజ్బెకిస్తాన్");
    namesMap.put("VA", "వేటికెన్");
    namesMap.put("VC", "సెంట్ విన్సెంట్ మరియు గ్రెనడీన్స్");
    namesMap.put("VE", "వెనుజువేలా");
    namesMap.put("VG", "బ్రిటిష్ వర్జిన్ దీవులు");
    namesMap.put("VI", "యు.ఎస్. వర్జిన్ దీవులు");
    namesMap.put("VN", "వియట్నాం");
    namesMap.put("VU", "వనౌటు");
    namesMap.put("WF", "వాలిస్ మరియు ఫ్యుత్యునా");
    namesMap.put("WS", "సమోవా");
    namesMap.put("YE", "యెమెన్");
    namesMap.put("YT", "మాయొట్టి");
    namesMap.put("ZA", "దక్షిణ ఆఫ్రికా రాజ్యం");
    namesMap.put("ZM", "జాంబియా");
    namesMap.put("ZW", "జింబాబ్వే");
    namesMap.put("ZZ", "తెలియని లేదా చెల్లని ప్రాంతం");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "ప్రపంచం",
        "002": "ఆఫ్రికా",
        "003": "ఉత్తర అమెరికా ఖండము",
        "005": "దక్షిణ అమెరికా",
        "009": "ఒషేనియ",
        "011": "పడమటి ఆఫ్రికా",
        "013": "మధ్యమ అమెరికా",
        "014": "తూర్పు ఆఫ్రికా",
        "015": "ఉత్తర ఆఫ్రికా",
        "017": "మధ్యమ ఆఫ్రికా",
        "018": "దక్షిణ ఆఫ్రికా",
        "019": "అమెరికాలు",
        "021": "ఉత్తర అమెరికా",
        "029": "కరిబ్బియన్",
        "030": "తూర్పు ఆశియా",
        "034": "దక్షిణ ఆశియా",
        "035": "నైరుతి ఆశియా",
        "039": "దక్షిణ ఐరోపా",
        "053": "ఆస్ట్రేలియా మరియు న్యూజిలాండ్",
        "054": "మెలనేశియ",
        "057": "మైక్రోనేశియ ప్రాంతం",
        "061": "పాలినేషియా",
        "062": "దక్షిణ మధ్యమ ఆశియా",
        "142": "ఆశియా",
        "143": "మధ్యమ ఆశియా",
        "145": "పడమటి ఆశియా",
        "150": "ఐరోపా",
        "151": "తూర్పు ఐరోపా",
        "154": "ఉత్తర ఐరోపా",
        "155": "పడమటి ఐరోపా",
        "172": "స్వతంత్ర రాష్ట్రాల కామన్ వెల్త్",
        "200": "చెకస్లొవేకియ",
        "419": "లాటిన్ అమెరికా మరియు కేరబ్బియన్",
        "830": "చానెల్ దీవులు",
        "AC": "ఎసెషన్ దీవి",
        "AD": "అన్డోరా",
        "AE": "యునైటెడ్ ఆరబ్ ఎమిరేట్స్",
        "AF": "ఆఫ్ఘానిస్తాన్",
        "AG": "ఆంటిగ్వా మరియు బార్బుడా",
        "AI": "ఆంగవిల్లా",
        "AL": "అల్బేనియా",
        "AM": "ఆర్మేనియా",
        "AN": "నేదేర్లేండ్స్ అంటిల్లిస్",
        "AO": "అంగోలా",
        "AQ": "అంటార్కటికా",
        "AR": "ఆర్జెంటినా",
        "AS": "అమెరికన్ సమోవా",
        "AT": "ఆస్ట్రియా",
        "AU": "ఆస్ట్రేలియా",
        "AW": "అరుబా",
        "AX": "ఆలేండ్ దీవులు",
        "AZ": "అజర్బైజాన్",
        "BA": "బాస్నియా మరియు హీర్జిగోవినా",
        "BB": "బార్బడోస్",
        "BD": "బాంగ్లాదేష్",
        "BE": "బెల్జియం",
        "BF": "బుర్కినా ఫాసో",
        "BG": "బల్గేరియా",
        "BH": "బహరేన్",
        "BI": "బురుండి",
        "BJ": "బెనిన్",
        "BL": "సెంట్ బర్తేలెమీ",
        "BM": "బర్మయుడా",
        "BN": "బ్రునై",
        "BO": "బొలీవియా",
        "BR": "బ్రజిల్",
        "BS": "బహామాస్",
        "BT": "భూటాన్",
        "BV": "బొవెట్ దీవి",
        "BW": "బోట్స్వానా",
        "BY": "బెలారస్",
        "BZ": "బెలీజ్",
        "CA": "కెనడా",
        "CC": "కోకోస్ దీవులు",
        "CD": "కాంగో- కిన్షాసా",
        "CF": "మధ్యమ ఆఫ్రికా రిపబ్లిక్",
        "CG": "కాంగో- బ్రాజావిల్లి",
        "CH": "స్విట్జర్లేండ్",
        "CI": "ఐవరీ కోస్ట్",
        "CK": "కుక్ దీవులు",
        "CL": "చిలి",
        "CM": "కెమరూన్",
        "CN": "చైనా",
        "CO": "కొలంబియా",
        "CP": "క్లిప్పర్టన్ దీవి",
        "CR": "కోస్టారికా",
        "CS": "సర్బియా మరియు మంటెనీగ్రో",
        "CU": "క్యూబా",
        "CV": "కేప్ వెర్డే",
        "CX": "క్రిస్మస్ దీవి",
        "CY": "సైప్రస్",
        "CZ": "చెక్ గణరాజ్యం",
        "DE": "ఙర్మని",
        "DG": "డియాగో గార్సియా",
        "DJ": "జిబౌటి",
        "DK": "డెన్మార్క్",
        "DM": "డోమెనిక",
        "DO": "డొమినికన్ గణ రాజ్యం",
        "DZ": "అల్జీరియా",
        "EA": "స్యూటా మరియు మెలిల్లా",
        "EC": "ఈక్వడోర్",
        "EE": "ఎస్టోనియా",
        "EG": "ఈజిప్ట్",
        "EH": "పడమటి సహారా",
        "ER": "ఎరిట్రియా",
        "ES": "స్పేన్",
        "ET": "ఇథియోపియా",
        "EU": "యురోపియన్ యునియన్",
        "FI": "ఫిన్లాండ్",
        "FJ": "ఫిజి",
        "FK": "ఫాక్ లేండ్ దీవులు",
        "FM": "మైక్రోనేశియ",
        "FO": "ఫారో దీవులు",
        "FR": "ఫ్రాన్స్‌",
        "GA": "గేబన్",
        "GB": "బ్రిటన్",
        "GD": "గ్రెనెడా",
        "GE": "జార్జియా",
        "GF": "ఫ్రెంచ్ గియానా",
        "GG": "గ్వేర్నసే",
        "GH": "ఘానా",
        "GI": "జిబ్రాల్టార్",
        "GL": "గ్రీన్లేండ్",
        "GM": "గాంబియా",
        "GN": "గినియా",
        "GP": "గ్వాడేలోప్",
        "GQ": "ఎక్వేటోరియాల్ గినియా",
        "GR": "గ్రీస్",
        "GS": "దక్షిణ జార్జియా మరియు దక్షిణ సాండ్విచ్ దీవులు",
        "GT": "గ్వాటిమాల",
        "GU": "గ్వామ్",
        "GW": "గినియా-బిస్సావ్",
        "GY": "గయానా",
        "HK": "హాంగ్ కాంగ్",
        "HM": "హెర్డ్ దీవి మరియు మాక్ డోనాల్డ్ దీవులు",
        "HN": "హోండోరాస్",
        "HR": "క్రోయేషియా",
        "HT": "హైటి",
        "HU": "హన్గేరి",
        "IC": "కేనరీ దీవులు",
        "ID": "ఇండోనేషియా",
        "IE": "ఐర్ లాండ్",
        "IL": "ఇస్రాయేల్",
        "IM": "ఐల్ ఆఫ్ మాన్",
        "IN": "భారత దేశం",
        "IO": "బ్రిటిష్ భారతీయ ఓషన్ ప్రాంతం",
        "IQ": "ఇరాక్",
        "IR": "ఇరాన్",
        "IS": "ఐస్లాండ్",
        "IT": "ఇటలి",
        "JE": "జర్సి",
        "JM": "జమైకా",
        "JO": "జార్డాన్",
        "JP": "జపాన్",
        "KE": "కెన్యా",
        "KG": "కిర్జిస్తాన్",
        "KH": "కంబోడియా",
        "KI": "కిరిబాటి",
        "KM": "కొమొరోస్",
        "KN": "సెంట్ కిట్ట్స్ మరియు నెవిస్",
        "KP": "ఉత్తర కొరియా",
        "KR": "దక్షిణ కొరియా",
        "KW": "కువైట్",
        "KY": "కేమాన్ దీవులు",
        "KZ": "కజాఖస్తాన్",
        "LA": "లావోస్",
        "LB": "లెబనాన్",
        "LC": "సెంట్ లూసియా",
        "LI": "లిక్టెస్టేన్",
        "LK": "శ్రీలంక",
        "LR": "లైబీరియా",
        "LS": "లెసోతో",
        "LT": "లిథుయేనియా",
        "LU": "లక్సంబర్గ్",
        "LV": "లాట్వియ",
        "LY": "లిబియా",
        "MA": "మొరాక్కో",
        "MC": "మొనాకో",
        "MD": "మోల్ డోవ",
        "ME": "మోంటేనేగ్రో",
        "MF": "సెంట్ మార్టిన్",
        "MG": "మాడ్గాస్కార్",
        "MH": "మార్షల్ దీవులు",
        "MK": "మేసెడోనియా",
        "ML": "మాలి",
        "MM": "మ్యాన్మార్",
        "MN": "మంగోలియా",
        "MO": "మాకావ్",
        "MP": "ఉత్తర మరియానా దీవులు",
        "MQ": "మార్టినిక్",
        "MR": "మౌరిటేనియా",
        "MS": "మోంట్సేర్రాట్",
        "MT": "మాల్టా",
        "MU": "మారిషస్",
        "MV": "మాల్దీవులు",
        "MW": "మాలావి",
        "MX": "మెక్సికో",
        "MY": "మలేషియా",
        "MZ": "మొజాంబిక్",
        "NA": "నమీబియా",
        "NC": "క్రొత్త కాలెడోనియా",
        "NE": "నైజర్",
        "NF": "నార్ఫాక్ దీవి",
        "NG": "నైజీరియా",
        "NI": "నికరాగువా",
        "NL": "నేదర్లాండ్స్",
        "NO": "నారవే",
        "NP": "నేపాల్",
        "NR": "నౌరు",
        "NU": "నియు",
        "NZ": "న్యుజిలేండ్",
        "OM": "ఒమాన్",
        "PA": "పనామా",
        "PE": "పెరూ",
        "PF": "ఫ్రెంచ్ పోలినిషియా",
        "PG": "పాపువా న్యు గినియా",
        "PH": "ఫిలి పైన్స్",
        "PK": "పాకిస్తాన్",
        "PL": "పోలాండ్",
        "PM": "సెంట్ పియెర్ మరియు మికెలాన్",
        "PN": "పిట్కెర్న్",
        "PR": "పోటోరికో",
        "PS": "పాలిస్తినియాన్ ప్రాంతం",
        "PT": "పోర్చుగల్",
        "PW": "పలావు",
        "PY": "పెరగువే",
        "QA": "కతర్",
        "QO": "ఒషేనియా బయటున్నవి",
        "RE": "రియూనియన్",
        "RO": "రోమానియా",
        "RS": "సెర్బియా",
        "RU": "రష్య",
        "RW": "ర్వాండా",
        "SA": "సౌదీ అరేబియా",
        "SB": "సోలోమన్ దీవులు",
        "SC": "సీషెల్స్",
        "SD": "సుడాన్",
        "SE": "స్వీడన్",
        "SG": "సింగపూర్",
        "SH": "సెంట్ హెలినా",
        "SI": "స్లోవేనియా",
        "SJ": "స్వాల్బార్డ్ మరియు యాన్ మాయేన్",
        "SK": "స్లోవేకియా",
        "SL": "సియెర్రా లియాన్",
        "SM": "సాన్ మారినో",
        "SN": "సెనెగల్",
        "SO": "సోమాలియా",
        "SR": "సురినామ్",
        "ST": "సావోటోమ్ మరియు ప్రిన్సిపే",
        "SV": "ఎల్ సాల్వడోర్",
        "SY": "సిరియా",
        "SZ": "స్వాజీలేండ్",
        "TA": "ట్రిస్టన్ డ కన్హా",
        "TC": "తుర్క్ మరియు కాలికోస్ దీవులు",
        "TD": "చాద్",
        "TF": "ఫ్రెంచ్ దక్షిణ ప్రాంతాలు",
        "TG": "టోగో",
        "TH": "థాయ్ లాండ్",
        "TJ": "టాజీకిస్తాన్",
        "TK": "టోకేలావ్",
        "TL": "టిమోర్-లెస్టె",
        "TM": "తుర్కమెస్తాన్",
        "TN": "ట్యునీషియా",
        "TO": "టోంగా",
        "TR": "టర్కీ",
        "TT": "ట్రినిడేడ్ మరియు టొబాగో",
        "TV": "టువాలు",
        "TW": "టైవాన్",
        "TZ": "టాంజానియా",
        "UA": "యుక్రెన్",
        "UG": "యుగాండా",
        "UM": "సంయుక్త రాజ్య అమెరికా యునైటెడ్ స్టేట్స్ మైనర్ బయట ఉన్న దీవులు",
        "US": "సంయుక్త రాజ్య అమెరికా",
        "UY": "ఉరుగువే",
        "UZ": "ఉజ్బెకిస్తాన్",
        "VA": "వేటికెన్",
        "VC": "సెంట్ విన్సెంట్ మరియు గ్రెనడీన్స్",
        "VE": "వెనుజువేలా",
        "VG": "బ్రిటిష్ వర్జిన్ దీవులు",
        "VI": "యు.ఎస్. వర్జిన్ దీవులు",
        "VN": "వియట్నాం",
        "VU": "వనౌటు",
        "WF": "వాలిస్ మరియు ఫ్యుత్యునా",
        "WS": "సమోవా",
        "YE": "యెమెన్",
        "YT": "మాయొట్టి",
        "ZA": "దక్షిణ ఆఫ్రికా రాజ్యం",
        "ZM": "జాంబియా",
        "ZW": "జింబాబ్వే",
        "ZZ": "తెలియని లేదా చెల్లని ప్రాంతం"
    };
  }-*/;
}
