/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.gwt.poll;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.AbstractRemoteServiceServlet;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RPCServletUtils;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import com.google.gwt.user.server.rpc.UnexpectedException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.DefaultBroadcaster;

public class AtmospherePollService
extends AbstractRemoteServiceServlet
implements SerializationPolicyProvider {
    public static final String GWT_SUSPENDED = "GWT_SUSPENDED";
    public static final String GWT_REQUEST = "GWT_REQUEST";
    private final Map<String, SerializationPolicy> serializationPolicyCache = new HashMap<String, SerializationPolicy>();

    protected SuspendInfo suspend() {
        AtmosphereResource<HttpServletRequest, HttpServletResponse> atm = this.getAtmosphereResource();
        if (atm == null) {
            throw new UnexpectedException("Failed to find Atmosphere resource have you setup Atmosphere?", null);
        }
        ((HttpServletRequest)atm.getRequest()).setAttribute(GWT_SUSPENDED, (Object)true);
        atm.suspend(-1L, false);
        return new SuspendInfo(atm);
    }

    protected SuspendInfo suspend(long timeout) {
        AtmosphereResource<HttpServletRequest, HttpServletResponse> atm = this.getAtmosphereResource();
        ((HttpServletRequest)atm.getRequest()).setAttribute(GWT_SUSPENDED, (Object)true);
        atm.suspend(timeout, false);
        return new SuspendInfo(atm);
    }

    protected boolean isSuspended() {
        AtmosphereResource<HttpServletRequest, HttpServletResponse> atm = this.getAtmosphereResource();
        if (atm == null) {
            throw new UnexpectedException("Failed to find Atmosphere resource have you setup Atmosphere?", null);
        }
        Boolean var = (Boolean)((HttpServletRequest)atm.getRequest()).getAttribute(GWT_SUSPENDED);
        return Boolean.TRUE.equals(var);
    }

    static void writeResponse(AtmosphereResource<HttpServletRequest, HttpServletResponse> resource, Object message) throws IOException {
        try {
            RPCRequest rpcRequest = (RPCRequest)((HttpServletRequest)resource.getRequest()).getAttribute(GWT_REQUEST);
            String response = AtmospherePollService.encodeResponse(rpcRequest, message);
            AtmospherePollService.writeResponse((HttpServletRequest)resource.getRequest(), (HttpServletResponse)resource.getResponse(), resource.getAtmosphereConfig().getServletContext(), response);
        }
        catch (IncompatibleRemoteServiceException ex) {
            try {
                String error = RPC.encodeResponseForFailure(null, (Throwable)ex);
                AtmospherePollService.writeResponse((HttpServletRequest)resource.getRequest(), (HttpServletResponse)resource.getResponse(), resource.getAtmosphereConfig().getServletContext(), error);
            }
            catch (SerializationException ex2) {
                throw new IOException(ex2);
            }
        }
        catch (SerializationException ex) {
            throw new IOException(ex);
        }
    }

    static String encodeResponse(RPCRequest rpcRequest, Object message) throws SerializationException {
        if (rpcRequest == null) {
            throw new NullPointerException("rpcRequest");
        }
        if (rpcRequest.getSerializationPolicy() == null) {
            throw new NullPointerException("serializationPolicy");
        }
        String responsePayload = RPC.encodeResponseForSuccess((Method)rpcRequest.getMethod(), (Object)message, (SerializationPolicy)rpcRequest.getSerializationPolicy(), (int)rpcRequest.getFlags());
        return responsePayload;
    }

    protected void onAfterRequestDeserialized(RPCRequest rpcRequest) {
        ((HttpServletRequest)this.getAtmosphereResource().getRequest()).setAttribute(GWT_REQUEST, (Object)rpcRequest);
    }

    private AtmosphereResource<HttpServletRequest, HttpServletResponse> getAtmosphereResource() {
        AtmosphereResource atm = (AtmosphereResource)this.getThreadLocalRequest().getAttribute(AtmosphereServlet.ATMOSPHERE_RESOURCE);
        if (atm == null) {
            throw new UnexpectedException("Failed to find Atmosphere resource have you setup Atmosphere?", null);
        }
        return atm;
    }

    public final void processPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, SerializationException {
        String requestPayload = this.readContent(request);
        this.onBeforeRequestDeserialized(requestPayload);
        String responsePayload = this.processCall(requestPayload);
        if (!this.isSuspended()) {
            this.onAfterResponseSerialized(responsePayload);
            AtmospherePollService.writeResponse(request, response, this.getServletContext(), responsePayload);
        }
    }

    protected static boolean shouldCompressResponse(HttpServletRequest request, HttpServletResponse response, String responsePayload) {
        return RPCServletUtils.exceedsUncompressedContentLengthLimit((String)responsePayload);
    }

    protected static void writeResponse(HttpServletRequest request, HttpServletResponse response, ServletContext context, String responsePayload) throws IOException {
        boolean gzipEncode = RPCServletUtils.acceptsGzipEncoding((HttpServletRequest)request) && AtmospherePollService.shouldCompressResponse(request, response, responsePayload);
        RPCServletUtils.writeResponse((ServletContext)context, (HttpServletResponse)response, (String)responsePayload, (boolean)gzipEncode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SerializationPolicy loadSerializationPolicy(HttpServlet servlet, HttpServletRequest request, String moduleBaseURL, String strongName) {
        String contextPath = request.getContextPath();
        String modulePath = null;
        if (moduleBaseURL != null) {
            try {
                modulePath = new URL(moduleBaseURL).getPath();
            }
            catch (MalformedURLException ex) {
                servlet.log("Malformed moduleBaseURL: " + moduleBaseURL, (Throwable)ex);
            }
        }
        SerializationPolicy serializationPolicy = null;
        if (modulePath == null || !modulePath.startsWith(contextPath)) {
            String message = "ERROR: The module path requested, " + modulePath + ", is not in the same web application as this servlet, " + contextPath + ".  Your module may not be properly configured or your client and server code maybe out of date.";
            servlet.log(message, null);
        } else {
            String contextRelativePath = modulePath.substring(contextPath.length());
            String serializationPolicyFilePath = SerializationPolicyLoader.getSerializationPolicyFileName((String)(contextRelativePath + strongName));
            InputStream is = servlet.getServletContext().getResourceAsStream(serializationPolicyFilePath);
            try {
                if (is != null) {
                    try {
                        serializationPolicy = SerializationPolicyLoader.loadFromStream((InputStream)is, null);
                    }
                    catch (ParseException e) {
                        servlet.log("ERROR: Failed to parse the policy file '" + serializationPolicyFilePath + "'", (Throwable)e);
                    }
                    catch (IOException e) {
                        servlet.log("ERROR: Could not read the policy file '" + serializationPolicyFilePath + "'", (Throwable)e);
                    }
                } else {
                    String message = "ERROR: The serialization policy file '" + serializationPolicyFilePath + "' was not found; did you forget to include it in this deployment?";
                    servlet.log(message);
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return serializationPolicy;
    }

    public final SerializationPolicy getSerializationPolicy(String moduleBaseURL, String strongName) {
        SerializationPolicy serializationPolicy = this.getCachedSerializationPolicy(moduleBaseURL, strongName);
        if (serializationPolicy != null) {
            return serializationPolicy;
        }
        serializationPolicy = this.doGetSerializationPolicy(this.getThreadLocalRequest(), moduleBaseURL, strongName);
        if (serializationPolicy == null) {
            this.log("WARNING: Failed to get the SerializationPolicy '" + strongName + "' for module '" + moduleBaseURL + "'; a legacy, 1.3.3 compatible, serialization policy will be used.  You may experience SerializationExceptions as a result.", null);
            serializationPolicy = RPC.getDefaultSerializationPolicy();
        }
        this.putCachedSerializationPolicy(moduleBaseURL, strongName, serializationPolicy);
        return serializationPolicy;
    }

    public String processCall(String payload) throws SerializationException {
        try {
            RPCRequest rpcRequest = RPC.decodeRequest((String)payload, ((Object)((Object)this)).getClass(), (SerializationPolicyProvider)this);
            this.onAfterRequestDeserialized(rpcRequest);
            return RPC.invokeAndEncodeResponse((Object)((Object)this), (Method)rpcRequest.getMethod(), (Object[])rpcRequest.getParameters(), (SerializationPolicy)rpcRequest.getSerializationPolicy(), (int)rpcRequest.getFlags());
        }
        catch (IncompatibleRemoteServiceException ex) {
            this.log("An IncompatibleRemoteServiceException was thrown while processing this call.", ex);
            return RPC.encodeResponseForFailure(null, (Throwable)ex);
        }
    }

    protected SerializationPolicy doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        return AtmospherePollService.loadSerializationPolicy((HttpServlet)this, request, moduleBaseURL, strongName);
    }

    protected void onAfterResponseSerialized(String serializedResponse) {
    }

    protected void onBeforeRequestDeserialized(String serializedRequest) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SerializationPolicy getCachedSerializationPolicy(String moduleBaseURL, String strongName) {
        Map<String, SerializationPolicy> map = this.serializationPolicyCache;
        synchronized (map) {
            return this.serializationPolicyCache.get(moduleBaseURL + strongName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putCachedSerializationPolicy(String moduleBaseURL, String strongName, SerializationPolicy serializationPolicy) {
        Map<String, SerializationPolicy> map = this.serializationPolicyCache;
        synchronized (map) {
            this.serializationPolicyCache.put(moduleBaseURL + strongName, serializationPolicy);
        }
    }

    public class SuspendInfo {
        private AtmosphereResource<HttpServletRequest, HttpServletResponse> atm;

        SuspendInfo(AtmosphereResource atm) {
            this.atm = atm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeAndResume(Object message) throws IOException {
            try {
                AtmospherePollService.writeResponse(this.atm, message);
            }
            finally {
                ((HttpServletRequest)this.atm.getRequest()).removeAttribute(AtmospherePollService.GWT_SUSPENDED);
                this.atm.resume();
            }
        }

        public Broadcaster getBroadcaster() {
            return this.atm.getBroadcaster();
        }

        public Broadcaster createBroadcaster(String ID) {
            try {
                Broadcaster b = BroadcasterFactory.getDefault().get(DefaultBroadcaster.class, (Object)ID);
                this.atm.setBroadcaster(b);
                return b;
            }
            catch (IllegalAccessException e) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
            return null;
        }
    }
}

