/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.gwt.server.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.atmosphere.gwt.server.impl.GwtAtmosphereResourceImpl;
import org.atmosphere.gwt.server.impl.GwtResponseWriterImpl;
import org.atmosphere.gwt.shared.server.SerializationException;

public class WebsocketResponseWriter
extends GwtResponseWriterImpl {
    private static final String MESSAGE_SEPERATOR = "#@@#";

    public WebsocketResponseWriter(GwtAtmosphereResourceImpl resource) {
        super(resource);
    }

    @Override
    public void initiate() throws IOException {
        super.initiate();
        this.writer.append("c;c;").append(String.valueOf(this.resource.getHeartBeatInterval())).append(';').append(String.valueOf(this.resource.getConnectionUUID())).append(MESSAGE_SEPERATOR);
    }

    @Override
    protected boolean supportsDeflate() {
        return false;
    }

    @Override
    protected void doSendError(int statusCode, String message) throws IOException {
        this.writer.append("c;e;").append(String.valueOf(statusCode));
        if (message != null) {
            this.writer.append(";").append(message);
        }
        this.writer.append(MESSAGE_SEPERATOR);
    }

    @Override
    protected void doSuspend() throws IOException {
    }

    @Override
    protected void doWrite(List<? extends Serializable> messages) throws IOException, SerializationException {
        for (Serializable serializable : messages) {
            char event;
            CharSequence string;
            if (serializable instanceof CharSequence) {
                string = (CharSequence)((Object)serializable);
                event = 's';
            } else {
                string = this.serialize(serializable);
                event = 'o';
            }
            this.writer.append(event).append(";");
            this.writer.append(string).append(MESSAGE_SEPERATOR);
        }
    }

    @Override
    protected void doHeartbeat() throws IOException {
        this.writer.append("c;h").append(MESSAGE_SEPERATOR);
    }

    @Override
    public void doTerminate() throws IOException {
        this.writer.append("c;d").append(MESSAGE_SEPERATOR);
    }
}

