/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.hazelcast;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MessageListener;
import java.net.URI;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.util.AbstractBroadcasterProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastBroadcaster
extends AbstractBroadcasterProxy {
    private static final Logger logger = LoggerFactory.getLogger(HazelcastBroadcaster.class);
    private ITopic topic;

    public HazelcastBroadcaster(String id, AtmosphereConfig config) {
        this(id, URI.create("http://localhost:6379"), config);
    }

    public HazelcastBroadcaster(String id, URI uri, AtmosphereConfig config) {
        super(id, uri, config);
    }

    public void setUp() {
        this.topic = Hazelcast.getTopic((String)this.getID());
    }

    public synchronized void setID(String id) {
        super.setID(id);
        this.setUp();
    }

    public void destroy() {
        this.topic.destroy();
    }

    public void incomingBroadcast() {
        logger.info("Subscribing to: {}", (Object)this.getID());
        this.topic.addMessageListener((MessageListener)new MessageListener<String>(){

            public void onMessage(String message) {
                HazelcastBroadcaster.this.broadcastReceivedMessage(message);
            }
        });
    }

    public void outgoingBroadcast(Object message) {
        this.topic.publish((Object)message.toString());
    }
}

