/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.hazelcast;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.util.AbstractBroadcasterProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastBroadcaster
extends AbstractBroadcasterProxy {
    private static final Logger logger = LoggerFactory.getLogger(HazelcastBroadcaster.class);
    private ITopic topic;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private String messageListenerRegistrationId;
    private static final HazelcastInstance HAZELCAST_INSTANCE = Hazelcast.newHazelcastInstance();

    public Broadcaster initialize(String id, AtmosphereConfig config) {
        return super.initialize(id, URI.create("http://localhost:6379"), config);
    }

    public Broadcaster initialize(String id, URI uri, AtmosphereConfig config) {
        return super.initialize(id, uri, config);
    }

    public void setUp() {
        this.topic = HAZELCAST_INSTANCE.getTopic(this.getID());
        this.config.shutdownHook(new AtmosphereConfig.ShutdownHook(){

            public void shutdown() {
                HAZELCAST_INSTANCE.shutdown();
                HazelcastBroadcaster.this.isClosed.set(true);
            }
        });
    }

    private synchronized void addMessageListener() {
        if (this.getAtmosphereResources().size() > 0 && this.messageListenerRegistrationId == null) {
            this.messageListenerRegistrationId = this.topic.addMessageListener((MessageListener)new MessageListener<String>(){

                public void onMessage(Message<String> message) {
                    HazelcastBroadcaster.this.broadcastReceivedMessage(message.getMessageObject());
                }
            });
            logger.info("Added message listener to topic");
        }
    }

    private synchronized void removeMessageListener() {
        if (this.getAtmosphereResources().size() == 0 && this.messageListenerRegistrationId != null) {
            this.getTopic().removeMessageListener(this.messageListenerRegistrationId);
            this.messageListenerRegistrationId = null;
            logger.info("Removed message listener from topic");
        }
    }

    public Broadcaster addAtmosphereResource(AtmosphereResource resource) {
        Broadcaster result = super.addAtmosphereResource(resource);
        this.addMessageListener();
        return result;
    }

    public Broadcaster removeAtmosphereResource(AtmosphereResource resource) {
        Broadcaster result = super.removeAtmosphereResource(resource);
        this.removeMessageListener();
        return result;
    }

    public synchronized void setID(String id) {
        super.setID(id);
        this.setUp();
    }

    public void destroy() {
        if (!this.isClosed.get()) {
            this.topic.destroy();
            this.topic = null;
        }
        super.destroy();
    }

    public void incomingBroadcast() {
        logger.info("Subscribing to: {}", (Object)this.getID());
    }

    public void outgoingBroadcast(Object message) {
        this.topic.publish(message);
    }

    protected ITopic getTopic() {
        return this.topic;
    }
}

