/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.jaxrs;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.core.ExecutionContext;
import javax.ws.rs.core.Response;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.jersey.util.JerseyBroadcasterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereExecutionContext
implements ExecutionContext {
    private final Logger logger = LoggerFactory.getLogger(AtmosphereExecutionContext.class);
    private final AtmosphereResourceImpl resource;
    private Object response;
    private TimeUnit unit;
    private long time = -1L;
    private AtomicBoolean resumed = new AtomicBoolean(false);

    public AtmosphereExecutionContext(AtmosphereResourceImpl r) {
        this.resource = r;
        this.resource.addEventListener((AtmosphereResourceEventListener)new AtmosphereResourceEventListenerAdapter(){

            public void onResume(AtmosphereResourceEvent event) {
                if (!AtmosphereExecutionContext.this.resumed.getAndSet(true)) {
                    try {
                        JerseyBroadcasterUtil.broadcast((AtmosphereResource)AtmosphereExecutionContext.this.resource, (AtmosphereResourceEvent)new AtmosphereResourceEventImpl(AtmosphereExecutionContext.this.resource, false, false, null).setMessage(AtmosphereExecutionContext.this.response), (Broadcaster)AtmosphereExecutionContext.this.resource.getBroadcaster());
                    }
                    finally {
                        Throwable t;
                        AtmosphereExecutionContext.this.logger.trace("", t);
                        try {
                            AtmosphereExecutionContext.this.resource.cancel();
                        }
                        catch (IOException e) {
                            AtmosphereExecutionContext.this.logger.trace("", t);
                        }
                    }
                }
            }
        });
    }

    public void resume(Object response) throws IllegalStateException {
        JerseyBroadcasterUtil.broadcast((AtmosphereResource)this.resource, (AtmosphereResourceEvent)new AtmosphereResourceEventImpl(this.resource, false, false, null).setMessage(response), (Broadcaster)this.resource.getBroadcaster());
        this.resource.resume();
    }

    public void resume(Exception response) throws IllegalStateException {
        throw new IllegalStateException("Not supported");
    }

    public void suspend() throws IllegalStateException {
        if (this.unit == null) {
            this.resource.suspend(-1L, false);
        } else {
            this.resource.suspend(this.time, this.unit, false);
        }
    }

    public void suspend(long millis) throws IllegalStateException {
        if (this.unit == null) {
            this.resource.suspend(millis);
        } else {
            this.resource.suspend(this.time, this.unit, false);
        }
    }

    public void suspend(long time, TimeUnit unit) throws IllegalStateException {
        if (this.unit == null) {
            this.resource.suspend(time, unit);
        } else {
            this.resource.suspend(time, unit, false);
        }
    }

    public void setSuspendTimeout(long time, TimeUnit unit) throws IllegalStateException {
        this.time = time;
        this.unit = unit;
    }

    public void cancel() {
        try {
            this.resource.cancel();
        }
        catch (IOException e) {
            this.logger.debug("", (Throwable)e);
        }
    }

    public boolean isSuspended() {
        return this.resource.isSuspended();
    }

    public boolean isCancelled() {
        return this.resource.isCancelled();
    }

    public boolean isDone() {
        return !this.isSuspended();
    }

    public void setResponse(Object response) {
        this.response = response;
    }

    public Response getResponse() {
        return Response.ok((Object)this.response).build();
    }
}

