/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cache.BroadcastMessage;
import org.atmosphere.cache.BroadcasterCacheInspector;
import org.atmosphere.cache.CacheMessage;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.util.ExecutorsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UUIDBroadcasterCache
implements BroadcasterCache {
    private static final Logger logger = LoggerFactory.getLogger(UUIDBroadcasterCache.class);
    private final Map<String, ClientQueue> messages = new HashMap<String, ClientQueue>();
    private final Map<String, Long> activeClients = new HashMap<String, Long>();
    protected final List<BroadcasterCacheInspector> inspectors = new LinkedList<BroadcasterCacheInspector>();
    private ScheduledFuture scheduledFuture;
    protected ScheduledExecutorService taskScheduler;
    private long clientIdleTime = TimeUnit.SECONDS.toMillis(60L);
    private long invalidateCacheInterval = TimeUnit.SECONDS.toMillis(30L);
    private boolean shared = true;
    protected final List<Object> emptyList = Collections.emptyList();

    @Override
    public void configure(BroadcasterConfig config) {
        Object o = config.getAtmosphereConfig().properties().get("shared");
        if (o != null) {
            this.shared = Boolean.parseBoolean(o.toString());
        }
        this.taskScheduler = this.shared ? ExecutorsFactory.getScheduler(config.getAtmosphereConfig()) : Executors.newSingleThreadScheduledExecutor();
    }

    @Override
    public void start() {
        this.scheduledFuture = this.taskScheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                UUIDBroadcasterCache.this.invalidateExpiredEntries();
            }
        }, 0L, this.invalidateCacheInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        this.cleanup();
        if (this.taskScheduler != null) {
            this.taskScheduler.shutdown();
        }
    }

    @Override
    public void cleanup() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheMessage addToCache(String broadcasterId, AtmosphereResource r, BroadcastMessage message) {
        Object e = message.message;
        if (logger.isTraceEnabled()) {
            logger.trace("Adding for AtmosphereResource {} cached messages {}", (Object)(r != null ? r.uuid() : "null"), e);
            logger.trace("Active clients {}", this.activeClients());
        }
        long now = System.currentTimeMillis();
        String messageId = UUID.randomUUID().toString();
        CacheMessage cacheMessage = new CacheMessage(messageId, e);
        Map<String, ClientQueue> map = this.messages;
        synchronized (map) {
            if (r == null) {
                for (Map.Entry<String, Long> entry : this.activeClients.entrySet()) {
                    this.addMessageIfNotExists(entry.getKey(), cacheMessage);
                }
            } else {
                String clientId = this.uuid(r);
                this.activeClients.put(clientId, now);
                this.addMessageIfNotExists(clientId, cacheMessage);
            }
        }
        return cacheMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> retrieveFromCache(String broadcasterId, AtmosphereResource r) {
        ClientQueue clientQueue;
        String clientId = this.uuid(r);
        long now = System.currentTimeMillis();
        ArrayList<Object> result = new ArrayList<Object>();
        Map<String, ClientQueue> map = this.messages;
        synchronized (map) {
            this.activeClients.put(clientId, now);
            clientQueue = this.messages.remove(clientId);
        }
        List<Object> clientMessages = clientQueue == null ? Collections.emptyList() : clientQueue.getQueue();
        for (CacheMessage cacheMessage : clientMessages) {
            result.add(cacheMessage.getMessage());
        }
        if (logger.isTraceEnabled()) {
            Map<String, ClientQueue> map2 = this.messages;
            synchronized (map2) {
                logger.trace("Retrieved for AtmosphereResource {} cached messages {}", (Object)r.uuid(), result);
                logger.trace("Available cached message {}", this.messages);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache(String broadcasterId, AtmosphereResource r, CacheMessage message) {
        if (message == null) {
            AtmosphereResourceEvent e = r.getAtmosphereResourceEvent();
            logger.trace("Cached message is null for {}, but event was {}", (Object)r.uuid(), e == null ? "null" : e.getMessage());
            return;
        }
        String clientId = this.uuid(r);
        Map<String, ClientQueue> map = this.messages;
        synchronized (map) {
            ClientQueue clientQueue = this.messages.get(clientId);
            if (clientQueue != null) {
                logger.trace("Removing for AtmosphereResource {} cached message {}", (Object)r.uuid(), message.getMessage());
                clientQueue.getQueue().remove(message);
            }
        }
    }

    @Override
    public BroadcasterCache inspector(BroadcasterCacheInspector b) {
        this.inspectors.add(b);
        return this;
    }

    protected String uuid(AtmosphereResource r) {
        return r.uuid();
    }

    private void addMessageIfNotExists(String clientId, CacheMessage message) {
        if (!this.hasMessage(clientId, message.getId())) {
            this.addMessage(clientId, message);
        } else {
            logger.debug("Duplicate message {} for client {}", (Object)clientId, (Object)message);
        }
    }

    private void addMessage(String clientId, CacheMessage message) {
        ClientQueue clientQueue = this.messages.get(clientId);
        if (clientQueue == null) {
            clientQueue = new ClientQueue();
            this.messages.put(clientId, clientQueue);
        }
        clientQueue.getQueue().addLast(message);
        clientQueue.getIds().add(message.getId());
    }

    private boolean hasMessage(String clientId, String messageId) {
        ClientQueue clientQueue = this.messages.get(clientId);
        return clientQueue != null && clientQueue.getIds().contains(messageId);
    }

    public Map<String, ClientQueue> messages() {
        return this.messages;
    }

    public Map<String, Long> activeClients() {
        return this.activeClients;
    }

    protected boolean inspect(BroadcastMessage m) {
        for (BroadcasterCacheInspector b : this.inspectors) {
            if (b.inspect(m)) continue;
            return false;
        }
        return true;
    }

    public void setInvalidateCacheInterval(long invalidateCacheInterval) {
        this.invalidateCacheInterval = invalidateCacheInterval;
        this.scheduledFuture.cancel(true);
        this.start();
    }

    public void setClientIdleTime(long clientIdleTime) {
        this.clientIdleTime = clientIdleTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateExpiredEntries() {
        long now = System.currentTimeMillis();
        Map<String, ClientQueue> map = this.messages;
        synchronized (map) {
            HashSet<String> inactiveClients = new HashSet<String>();
            for (Map.Entry<String, Long> entry : this.activeClients.entrySet()) {
                if (now - entry.getValue() <= this.clientIdleTime) continue;
                logger.debug("Invalidate client {}", (Object)entry.getKey());
                inactiveClients.add(entry.getKey());
            }
            for (String clientId : inactiveClients) {
                this.activeClients.remove(clientId);
                this.messages.remove(clientId);
            }
        }
    }

    @Override
    public void excludeFromCache(String broadcasterId, AtmosphereResource r) {
        this.activeClients.remove(r.uuid());
    }

    public String toString() {
        return this.getClass().getName();
    }

    public static final class ClientQueue {
        private final LinkedList<CacheMessage> queue = new LinkedList();
        private final Set<String> ids = new HashSet<String>();

        public LinkedList<CacheMessage> getQueue() {
            return this.queue;
        }

        public Set<String> getIds() {
            return this.ids;
        }

        public String toString() {
            return this.queue.toString();
        }
    }
}

