/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container.version;

import java.io.IOException;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.websocket.WebSocket;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.io.WebSocketBlockingConnection;

public class Jetty9WebSocket
extends WebSocket {
    private final Session webSocketConnection;
    private final WebSocketBlockingConnection blockingConnection;

    public Jetty9WebSocket(Session webSocketConnection, AtmosphereConfig config) {
        super(config);
        this.webSocketConnection = webSocketConnection;
        this.blockingConnection = new WebSocketBlockingConnection(webSocketConnection);
    }

    @Override
    public boolean isOpen() {
        return this.webSocketConnection.isOpen();
    }

    @Override
    public WebSocket write(String s) throws IOException {
        this.blockingConnection.write(s);
        return this;
    }

    @Override
    public WebSocket write(byte[] b, int offset, int length) throws IOException {
        this.blockingConnection.write(b, offset, length);
        return this;
    }

    @Override
    public void close() {
        logger.trace("WebSocket.close() for AtmosphereResource {}", (Object)(this.resource() != null ? this.resource().uuid() : "null"));
        try {
            this.webSocketConnection.close();
        }
        catch (Throwable e) {
            logger.trace("Close error", e);
        }
    }
}

