/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.BroadcasterLifeCyclePolicy;
import org.atmosphere.cpr.BroadcasterListener;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.di.InjectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBroadcasterFactory
extends BroadcasterFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBroadcasterFactory.class);
    private final ConcurrentHashMap<Object, Broadcaster> store = new ConcurrentHashMap();
    private final Class<? extends Broadcaster> clazz;
    private BroadcasterLifeCyclePolicy policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.NEVER).build();
    protected Broadcaster.POLICY defaultPolicy = Broadcaster.POLICY.FIFO;
    protected int defaultPolicyInteger = -1;

    protected DefaultBroadcasterFactory(Class<? extends Broadcaster> clazz, String broadcasterLifeCyclePolicy, AtmosphereConfig c) {
        this.clazz = clazz;
        factory = this;
        config = c;
        this.configure(broadcasterLifeCyclePolicy);
    }

    private void configure(String broadcasterLifeCyclePolicy) {
        int maxIdleTime = 300000;
        String s = config.getInitParameter(ApplicationConfig.BROADCASTER_LIFECYCLE_POLICY_IDLETIME);
        if (s != null) {
            maxIdleTime = Integer.parseInt(s);
        }
        if ((s = config.getInitParameter(ApplicationConfig.BROADCASTER_POLICY)) != null) {
            Broadcaster.POLICY pOLICY = this.defaultPolicy = s.equalsIgnoreCase(Broadcaster.POLICY.REJECT.name()) ? Broadcaster.POLICY.REJECT : Broadcaster.POLICY.FIFO;
        }
        if ((s = config.getInitParameter(ApplicationConfig.BROADCASTER_POLICY_TIMEOUT)) != null) {
            this.defaultPolicyInteger = Integer.valueOf(s);
        }
        if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY).build();
        } else if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY_DESTROY.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY_DESTROY).build();
        } else if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE).idleTimeInMS(maxIdleTime).build();
        } else if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_DESTROY.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_DESTROY).idleTimeInMS(maxIdleTime).build();
        } else if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_RESUME.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_RESUME).idleTimeInMS(maxIdleTime).build();
        } else if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.NEVER.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.NEVER).build();
        } else {
            logger.warn("Unsupported BroadcasterLifeCyclePolicy policy {}", (Object)broadcasterLifeCyclePolicy);
        }
    }

    @Override
    public final synchronized Broadcaster get() {
        return this.get(this.clazz.getSimpleName() + "-" + UUID.randomUUID());
    }

    @Override
    public final Broadcaster get(Object id) {
        return this.get(this.clazz, id);
    }

    @Override
    public final <T extends Broadcaster> T get(Class<T> c, Object id) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        if (c == null) {
            throw new NullPointerException("Class is null");
        }
        return this.lookup(c, id, true, true);
    }

    private <T extends Broadcaster> T createBroadcaster(Class<T> c, Object id) throws BroadcasterCreationException {
        try {
            Broadcaster b = (Broadcaster)c.getConstructor(String.class, AtmosphereConfig.class).newInstance(id.toString(), config);
            InjectorProvider.getInjector().inject(b);
            b.setSuspendPolicy(this.defaultPolicyInteger, this.defaultPolicy);
            if (b.getBroadcasterConfig() == null) {
                b.setBroadcasterConfig(new BroadcasterConfig(DefaultBroadcasterFactory.config.framework().broadcasterFilters, config, id.toString()));
            }
            b.setBroadcasterLifeCyclePolicy(this.policy);
            if (DefaultBroadcaster.class.isAssignableFrom(this.clazz)) {
                ((DefaultBroadcaster)DefaultBroadcaster.class.cast(b)).start();
            }
            for (BroadcasterListener l : this.broadcasterListeners) {
                b.addBroadcasterListener(l);
            }
            logger.trace("Broadcaster {} was created {}", id, (Object)b);
            this.notifyOnPostCreate(b);
            return (T)b;
        }
        catch (Throwable t) {
            throw new BroadcasterCreationException(t);
        }
    }

    @Override
    public boolean add(Broadcaster b, Object id) {
        return this.store.put(id, b) == null;
    }

    @Override
    public boolean remove(Broadcaster b, Object id) {
        boolean removed = this.store.remove(id, b);
        if (removed) {
            logger.debug("Removing Broadcaster {} factory size now {} ", id, (Object)this.store.size());
        }
        return removed;
    }

    @Override
    public final <T extends Broadcaster> T lookup(Class<T> c, Object id) {
        return this.lookup(c, id, false);
    }

    public final Broadcaster lookup(Object id) {
        return this.lookup(this.clazz, id, false);
    }

    public final Broadcaster lookup(Object id, boolean createIfNull) {
        return this.lookup(this.clazz, id, createIfNull);
    }

    @Override
    public <T extends Broadcaster> T lookup(Class<T> c, Object id, boolean createIfNull) {
        return this.lookup(c, id, createIfNull, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Broadcaster> T lookup(Class<T> c, Object id, boolean createIfNull, boolean unique) {
        Object object = id;
        synchronized (object) {
            logger.trace("About to create {}", id);
            if (unique && this.store.get(id) != null) {
                throw new IllegalStateException("Broadcaster already exists " + id + ". Use BroadcasterFactory.lookup instead");
            }
            Broadcaster b = this.store.get(id);
            logger.trace("Looking in the store using {} returned {}", id, (Object)b);
            if (b != null && !c.isAssignableFrom(b.getClass())) {
                String msg = "Invalid lookup class " + c.getName() + ". Cached class is: " + b.getClass().getName();
                logger.debug(msg);
                throw new IllegalStateException(msg);
            }
            if (b == null && createIfNull || b != null && b.isDestroyed()) {
                Broadcaster nb;
                if (b != null) {
                    logger.trace("Removing destroyed Broadcaster {}", (Object)b.getID());
                    this.store.remove(b.getID(), b);
                }
                if ((nb = this.store.get(id)) == null) {
                    nb = this.createBroadcaster(c, id);
                    this.store.put(id, nb);
                }
                if (nb == null) {
                    logger.trace("Added Broadcaster {} . Factory size: {}", id, (Object)this.store.size());
                }
                b = nb;
            }
            return (T)b;
        }
    }

    @Override
    public void removeAllAtmosphereResource(AtmosphereResource r) {
        try {
            if (this.store.size() > 0) {
                for (Broadcaster b : this.lookupAll()) {
                    try {
                        if (!b.getAtmosphereResources().contains(r)) continue;
                        b.removeAtmosphereResource(r);
                    }
                    catch (IllegalStateException ex) {
                        logger.trace(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public boolean remove(Object id) {
        return this.store.remove(id) != null;
    }

    @Override
    public Collection<Broadcaster> lookupAll() {
        return Collections.unmodifiableCollection(this.store.values());
    }

    @Override
    public synchronized void destroy() {
        String s = config.getInitParameter("org.atmosphere.runtime.shared");
        if (s != null && s.equalsIgnoreCase("true")) {
            logger.warn("Factory shared, will not be destroyed. This can possibly cause memory leaks ifBroadcasters were created. Make sure you destroy them manually.");
            return;
        }
        Enumeration<Broadcaster> e = this.store.elements();
        BroadcasterConfig bc = null;
        while (e.hasMoreElements()) {
            try {
                Broadcaster b = e.nextElement();
                b.resumeAll();
                bc = b.getBroadcasterConfig();
                bc.forceDestroy();
                b.destroy();
            }
            catch (Throwable t) {
                logger.debug("Destroy", t);
            }
        }
        this.store.clear();
        factory = null;
    }

    public void notifyOnPostCreate(Broadcaster b) {
        for (BroadcasterListener l : this.broadcasterListeners) {
            try {
                l.onPostCreate(b);
            }
            catch (Exception ex) {
                logger.warn("onPostCreate", (Throwable)ex);
            }
        }
    }

    public static BroadcasterFactory buildAndReplaceDefaultfactory(Class<? extends Broadcaster> clazz, AtmosphereConfig c) throws InstantiationException, IllegalAccessException {
        factory = new DefaultBroadcasterFactory(clazz, "NEVER", c);
        c.framework().setBroadcasterFactory(factory);
        return factory;
    }

    @Override
    public BroadcasterFactory addBroadcasterListener(BroadcasterListener l) {
        super.addBroadcasterListener(l);
        for (Broadcaster b : this.store.values()) {
            b.addBroadcasterListener(l);
        }
        return this;
    }

    @Override
    public BroadcasterFactory removeBroadcasterListener(BroadcasterListener l) {
        super.removeBroadcasterListener(l);
        for (Broadcaster b : this.store.values()) {
            b.removeBroadcasterListener(l);
        }
        return this;
    }

    public static final class BroadcasterCreationException
    extends RuntimeException {
        public BroadcasterCreationException(Throwable t) {
            super(t);
        }
    }
}

