/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;

public final class AtmosphereResourceFactory {
    private static final AtmosphereResourceFactory factory = new AtmosphereResourceFactory();
    private static final Broadcaster noOps = (Broadcaster)Proxy.newProxyInstance(Broadcaster.class.getClassLoader(), new Class[]{Broadcaster.class}, new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return null;
        }
    });
    private static final AtmosphereHandler noOpsHandler = (AtmosphereHandler)Proxy.newProxyInstance(AtmosphereHandler.class.getClassLoader(), new Class[]{AtmosphereHandler.class}, new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return null;
        }
    });
    private static final AtmosphereHandler voidAtmosphereHandler = new AbstractReflectorAtmosphereHandler(){

        @Override
        public void onRequest(AtmosphereResource resource) throws IOException {
        }

        @Override
        public void destroy() {
        }
    };

    public final AtmosphereResource create(AtmosphereConfig config, AtmosphereRequest request, AtmosphereResponse response, AsyncSupport<?> a) {
        return new AtmosphereResourceImpl(config, null, request, response, a, voidAtmosphereHandler);
    }

    public final AtmosphereResource create(AtmosphereConfig config, Broadcaster broadcaster, AtmosphereRequest request, AtmosphereResponse response, AsyncSupport<?> a, AtmosphereHandler handler) {
        return new AtmosphereResourceImpl(config, broadcaster, request, response, a, handler);
    }

    public final AtmosphereResource create(AtmosphereConfig config, Broadcaster broadcaster, AtmosphereResponse response, AsyncSupport<?> a, AtmosphereHandler handler) {
        return this.create(config, broadcaster, response.request(), response, a, handler);
    }

    public final AtmosphereResource create(AtmosphereConfig config, AtmosphereResponse response, AsyncSupport<?> a) {
        return new AtmosphereResourceImpl(config, null, response.request(), response, a, voidAtmosphereHandler);
    }

    public final AtmosphereResource create(AtmosphereConfig config, String uuid) {
        AtmosphereResponse response = AtmosphereResponse.newInstance();
        response.setHeader("X-Atmosphere-tracking-id", uuid);
        return AtmosphereResourceFactory.getDefault().create(config, noOps, AtmosphereRequest.newInstance(), response, config.framework().getAsyncSupport(), noOpsHandler);
    }

    public final AtmosphereResource remove(String uuid) {
        AtmosphereResource r = this.find(uuid);
        if (r != null) {
            r.getAtmosphereConfig().getBroadcasterFactory().removeAllAtmosphereResource(r);
        }
        return r;
    }

    public final AtmosphereResource find(String uuid) {
        Collection<Broadcaster> l = BroadcasterFactory.getDefault().lookupAll();
        for (Broadcaster b : l) {
            for (AtmosphereResource r : b.getAtmosphereResources()) {
                if (!r.uuid().equalsIgnoreCase(uuid)) continue;
                return r;
            }
        }
        return null;
    }

    public final Set<Broadcaster> broadcasters(String uuid) {
        Collection<Broadcaster> l = BroadcasterFactory.getDefault().lookupAll();
        HashSet<Broadcaster> h = new HashSet<Broadcaster>();
        for (Broadcaster b : l) {
            for (AtmosphereResource r : b.getAtmosphereResources()) {
                if (!r.uuid().equalsIgnoreCase(uuid)) continue;
                h.add(b);
            }
        }
        return h;
    }

    public static final AtmosphereResourceFactory getDefault() {
        return factory;
    }
}

