/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.FrameworkConfig;

public final class Utils {
    public static final boolean webSocketEnabled(HttpServletRequest request) {
        boolean allowWebSocketWithoutHeaders;
        boolean bl = allowWebSocketWithoutHeaders = request.getHeader("X-Atmosphere-WebSocket-Proxy") != null;
        if (allowWebSocketWithoutHeaders) {
            return true;
        }
        boolean webSocketEnabled = false;
        Enumeration connection = request.getHeaders("Connection");
        if (connection == null || !connection.hasMoreElements()) {
            connection = request.getHeaders("connection");
        }
        if (connection != null && connection.hasMoreElements()) {
            String[] e;
            for (String upgrade : e = ((String)connection.nextElement()).toString().split(",")) {
                if (!upgrade.trim().equalsIgnoreCase("Upgrade")) continue;
                webSocketEnabled = true;
                break;
            }
        }
        return webSocketEnabled;
    }

    public static final boolean firefoxWebSocketEnabled(HttpServletRequest request) {
        return Utils.webSocketEnabled(request) && request.getHeader("X-atmo-protocol") != null && request.getHeader("X-atmo-protocol").equals("true") && request.getHeader("User-Agent") != null && request.getHeader("User-Agent").toLowerCase().indexOf("firefox") != -1;
    }

    public static final boolean twoConnectionsTransport(AtmosphereResource.TRANSPORT t) {
        switch (t) {
            case JSONP: 
            case LONG_POLLING: 
            case STREAMING: 
            case SSE: 
            case POLLING: 
            case HTMLFILE: {
                return true;
            }
        }
        return false;
    }

    public static final boolean resumableTransport(AtmosphereResource.TRANSPORT t) {
        switch (t) {
            case JSONP: 
            case LONG_POLLING: {
                return true;
            }
        }
        return false;
    }

    public static final boolean pollableTransport(AtmosphereResource.TRANSPORT t) {
        switch (t) {
            case POLLING: 
            case UNDEFINED: 
            case AJAX: {
                return true;
            }
        }
        return false;
    }

    public static final boolean webSocketMessage(AtmosphereResource r) {
        AtmosphereRequest request = ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).getRequest(false);
        return request.getAttribute(FrameworkConfig.WEBSOCKET_MESSAGE) != null;
    }

    public static boolean properProtocol(HttpServletRequest request) {
        boolean isWebSocket;
        Enumeration connection = request.getHeaders("Connection");
        if (connection == null || !connection.hasMoreElements()) {
            connection = request.getHeaders("connection");
        }
        boolean isOK = false;
        boolean bl = isWebSocket = request.getHeader("sec-websocket-version") != null || request.getHeader("Sec-WebSocket-Draft") != null;
        if (connection != null && connection.hasMoreElements()) {
            String[] e;
            for (String upgrade : e = ((String)connection.nextElement()).toString().split(",")) {
                if (!upgrade.trim().equalsIgnoreCase("upgrade")) continue;
                isOK = true;
            }
        }
        return isWebSocket ? isOK : true;
    }
}

