/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForkJoinPool
extends AbstractExecutorService {
    private static final Logger logger = LoggerFactory.getLogger(ForkJoinPool.class);
    private final java.util.concurrent.ForkJoinPool forkJoinPool = new java.util.concurrent.ForkJoinPool(Runtime.getRuntime().availableProcessors(), new ForkJoinPool.ForkJoinWorkerThreadFactory(){

        @Override
        public ForkJoinWorkerThread newThread(java.util.concurrent.ForkJoinPool pool) {
            return new AtmosphereThreadFactoryJoin(pool);
        }
    }, null, true);

    public ForkJoinPool() {
        logger.info("Using ForkJoinPool. Set the {} to -1 to fully use its power.", (Object)"org.atmosphere.cpr.broadcaster.maxAsyncWriteThreads");
    }

    public java.util.concurrent.ForkJoinPool pool() {
        return this.forkJoinPool;
    }

    @Override
    public void shutdown() {
        this.forkJoinPool.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.forkJoinPool.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.forkJoinPool.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.forkJoinPool.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.forkJoinPool.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.forkJoinPool.execute(command);
    }

    private final class AtmosphereThreadFactoryJoin
    extends ForkJoinWorkerThread {
        private final AtomicInteger count;

        protected AtmosphereThreadFactoryJoin(java.util.concurrent.ForkJoinPool pool) {
            super(pool);
            this.count = new AtomicInteger();
            this.setName("Atmosphere-ForkJoinThreadShared-" + this.count.getAndIncrement());
        }
    }
}

