/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import com.sun.grizzly.websockets.WebSocketApplication;
import com.sun.grizzly.websockets.WebSocketEngine;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.atmosphere.container.GlassFishWebSocketHandler;
import org.atmosphere.container.GrizzlyCometSupport;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.util.Utils;
import org.atmosphere.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlassFishWebSocketSupport
extends GrizzlyCometSupport {
    private static final Logger logger = LoggerFactory.getLogger(GlassFishWebSocketSupport.class);
    private GlassFishWebSocketHandler glassfishWebSocketHandler;

    public GlassFishWebSocketSupport(AtmosphereConfig config) {
        super(config);
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.glassfishWebSocketHandler = new GlassFishWebSocketHandler(this.config);
        WebSocketEngine.getEngine().register((WebSocketApplication)this.glassfishWebSocketHandler);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        WebSocketEngine.getEngine().unregister((WebSocketApplication)this.glassfishWebSocketHandler);
        super.shutdown();
    }

    @Override
    public Action service(AtmosphereRequest request, AtmosphereResponse response) throws IOException, ServletException {
        boolean webSocketNotSupported;
        if (!Utils.webSocketEnabled(request)) {
            return super.service(request, response);
        }
        boolean bl = webSocketNotSupported = request.getAttribute(WebSocket.WEBSOCKET_SUSPEND) == null;
        if (webSocketNotSupported) {
            WebSocket.notSupported(request, response);
            return Action.CANCELLED;
        }
        return this.suspended(request, response);
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }
}

