/*
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://jersey.dev.java.net/CDDL+GPL.html
 * or jersey/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at jersey/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.atmosphere.jersey;

import com.sun.jersey.spi.StringReader;
import com.sun.jersey.spi.StringReaderProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.util.BroadcasterLookup;
import org.atmosphere.util.LoggerUtils;

/**
 * Placeholder for injection of Atmosphere object based on
 * any parameter value (header, cookie, query, matrix or path)
 *
 * @author Paul.Sandoz@Sun.Com
 * @author Jean-Francois Arcand
 */
public class AtmosphereProviders {

    public static class BroadcasterProvider implements StringReaderProvider {

        @Context HttpServletRequest req;

        public StringReader getStringReader(Class type, Type genericType, Annotation[] annotations) {
            if (type != Broadcaster.class) {
                return null;
            }

            return new StringReader() {

                public Object fromString(String topic) {
                    Broadcaster broadcaster = getBroadcaster(topic);

                    AtmosphereResource r = null;
                    // Just use the one we just got
                    if (broadcaster == null) {
                        if ((Boolean) req.getAttribute(AsynchronousProcessor.SUPPORT_SESSION)) {
                            r = (AtmosphereResource) req.getSession().
                                    getAttribute(AtmosphereFilter.SUSPENDED_RESOURCE);
                            if (r == null){
                                throw new WebApplicationException(
                                        new IllegalStateException("session-support not enabed"));
                            }
                            broadcaster = r.getBroadcaster();
                        } else {
                            try {
                                r = (AtmosphereResource) req.getAttribute(ReflectorServletProcessor.ATMOSPHERE_RESOURCE);
                                broadcaster = (Broadcaster) Thread.currentThread().getContextClassLoader()
                                    .loadClass((String)req.getAttribute
                                        (AtmosphereServlet.BROADCASTER_TYPE)).newInstance();
                                r.setBroadcaster(broadcaster);
                            } catch (Throwable ex) {
                                throw new WebApplicationException(ex);
                            }
                        }
                        
                        broadcaster.setID(topic);
                    }
                    return broadcaster;
                }
            };
        }

        private Broadcaster getBroadcaster(String topic) {
            try {
                return BroadcasterLookup.lookup(JerseyBroadcaster.class,topic);
            } catch (Throwable ex) {
                throw new WebApplicationException(ex);
            }
        }
    }
}
