package org.atmosphere.jersey.util;

import com.sun.jersey.spi.container.ContainerResponse;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.jersey.AtmosphereFilter;
import org.atmosphere.util.LoggerUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

/**
 * Simple util class shared among Jersey's Broadcaster.
 * 
 * @author Jeanfrancois Arcand
 */
public final class JerseyBroadcasterUtil {

    public final static void broadcast(final AtmosphereResource r, final AtmosphereResourceEvent e) {
        HttpServletRequest res = (HttpServletRequest)r.getRequest();

        try {
            ContainerResponse cr = (ContainerResponse)res.getAttribute(AtmosphereFilter.CONTAINER_RESPONSE);

            if (e.getMessage() instanceof Response){
                cr.setResponse((Response)e.getMessage());
                cr.write();
            } else {
                cr.reset();
                cr.setEntity(e.getMessage());

                cr.write();
                cr.getOutputStream().flush();
            }
            notifyListener(r,e);
        } catch (Throwable t){
            onException(t,r);
        } finally {
            Boolean resumeOnBroadcast = (Boolean)res.getAttribute(AtmosphereFilter.RESUME_ON_BROADCAST);
            if (resumeOnBroadcast != null && resumeOnBroadcast){

                String uuid = (String)res.getAttribute(AtmosphereFilter.RESUME_UUID);
                if (uuid != null){
                    if (res.getAttribute(AtmosphereFilter.RESUME_CANDIDATES) != null){
                        ((ConcurrentHashMap<String,AtmosphereResource>)res.getAttribute(AtmosphereFilter.RESUME_CANDIDATES)).remove(uuid);
                    }
                }

                notifyListener(r, new AtmosphereResourceEventImpl((AtmosphereResourceImpl)r,false,true));
                r.resume();
                removeListener(r,(ArrayList<AtmosphereResourceEventListener>)res.getAttribute(AtmosphereFilter.LISTENERS));
            }
        }
    }

    final static void notifyListener(AtmosphereResource<HttpServletRequest, HttpServletResponse> r,
                        AtmosphereResourceEvent e){
        AtmosphereHandler s = (AtmosphereHandler)
                r.getAtmosphereConfig().getAtmosphereHandler();
        if (s instanceof ReflectorServletProcessor){
            ((ReflectorServletProcessor)s).notifyListeners(e);
        }
    }

    final static void removeListener(AtmosphereResource<HttpServletRequest, HttpServletResponse> r,
                        ArrayList<AtmosphereResourceEventListener> l){
        AtmosphereHandler s = (AtmosphereHandler)
                r.getAtmosphereConfig().getAtmosphereHandler();
        if (l != null){
            for (AtmosphereResourceEventListener a: l){
                ((ReflectorServletProcessor)s).removeEventListener(a);
            }
        }
    }

    final static void onException(Throwable t, AtmosphereResource r){
        if(LoggerUtils.getLogger().isLoggable(Level.FINE)){
            LoggerUtils.getLogger().log(Level.FINE, "", t);
        }
        if (t instanceof IOException && r instanceof AtmosphereResourceImpl){
            notifyListener(r, new AtmosphereResourceEventImpl((AtmosphereResourceImpl)r,true,false));
            removeListener(r,(ArrayList<AtmosphereResourceEventListener>)
                    ((AtmosphereResourceImpl)r).getRequest()
                        .getAttribute(AtmosphereFilter.LISTENERS));
        }
        r.getBroadcaster().removeAtmosphereResource(r);
    }
}
