/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jersey.util;

import com.sun.jersey.spi.container.ContainerResponse;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.atmosphere.cpr.AtmosphereEventLifecycle;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.util.LoggerUtils;

public final class JerseyBroadcasterUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void broadcast(AtmosphereResource r, AtmosphereResourceEvent e) {
        HttpServletRequest res = (HttpServletRequest)r.getRequest();
        try {
            ContainerResponse cr = (ContainerResponse)res.getAttribute("cr");
            if (e.getMessage() instanceof Response) {
                cr.setResponse((Response)e.getMessage());
                cr.write();
            } else {
                cr.reset();
                cr.setEntity(e.getMessage());
                cr.write();
                cr.getOutputStream().flush();
            }
            if (r instanceof AtmosphereEventLifecycle) {
                ((AtmosphereEventLifecycle)r).notifyListeners();
            }
        }
        catch (Throwable t) {
            JerseyBroadcasterUtil.onException(t, r);
        }
        finally {
            Boolean resumeOnBroadcast = (Boolean)res.getAttribute("org.atmosphere.resumeOnBroadcast");
            if (resumeOnBroadcast != null && resumeOnBroadcast.booleanValue()) {
                String uuid = (String)res.getAttribute("org.atmosphere.jersey.uuid");
                if (uuid != null && res.getAttribute("org.atmosphere.jersey.resumeCandidates") != null) {
                    ((ConcurrentHashMap)res.getAttribute("org.atmosphere.jersey.resumeCandidates")).remove(uuid);
                }
                r.resume();
            }
        }
    }

    static final void onException(Throwable t, AtmosphereResource r) {
        if (LoggerUtils.getLogger().isLoggable(Level.FINE)) {
            LoggerUtils.getLogger().log(Level.FINE, "", t);
        }
        if (t instanceof IOException && r instanceof AtmosphereEventLifecycle) {
            ((AtmosphereEventLifecycle)r).notifyListeners((AtmosphereResourceEvent)new AtmosphereResourceEventImpl((AtmosphereResourceImpl)r, true, false));
            ((AtmosphereEventLifecycle)r).removeEventListeners();
        }
        r.getBroadcaster().removeAtmosphereResource(r);
    }
}

