/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jersey;

import com.sun.jersey.spi.StringReader;
import com.sun.jersey.spi.StringReaderProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.jersey.JerseyBroadcaster;
import org.atmosphere.util.BroadcasterLookup;

public class AtmosphereProviders {

    public static class BroadcasterProvider
    implements StringReaderProvider {
        @Context
        HttpServletRequest req;

        public StringReader getStringReader(Class type, Type genericType, Annotation[] annotations) {
            if (type != Broadcaster.class) {
                return null;
            }
            return new StringReader(){

                public Object fromString(String topic) {
                    Broadcaster broadcaster = BroadcasterProvider.this.getBroadcaster(topic);
                    AtmosphereResource r = null;
                    if (broadcaster == null) {
                        if (((Boolean)BroadcasterProvider.this.req.getAttribute("org.atmosphere.cpr.AsynchronousProcessor.supportSession")).booleanValue()) {
                            r = (AtmosphereResource)BroadcasterProvider.this.req.getSession().getAttribute("org.atmosphere.suspendedResource");
                            if (r == null) {
                                throw new WebApplicationException((Throwable)new IllegalStateException("session-support not enabed"));
                            }
                            broadcaster = r.getBroadcaster();
                        } else {
                            try {
                                r = (AtmosphereResource)BroadcasterProvider.this.req.getAttribute(ReflectorServletProcessor.ATMOSPHERE_RESOURCE);
                                broadcaster = (Broadcaster)Thread.currentThread().getContextClassLoader().loadClass((String)BroadcasterProvider.this.req.getAttribute("org.atmosphere.cpr.broadcasterClass")).newInstance();
                                r.setBroadcaster(broadcaster);
                            }
                            catch (Throwable ex) {
                                throw new WebApplicationException(ex);
                            }
                        }
                        broadcaster.setID(topic);
                    }
                    return broadcaster;
                }
            };
        }

        private Broadcaster getBroadcaster(String topic) {
            try {
                return BroadcasterLookup.lookup(JerseyBroadcaster.class, (Object)topic);
            }
            catch (Throwable ex) {
                throw new WebApplicationException(ex);
            }
        }
    }
}

