/*
*
* DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
*
* Copyright 2007-2008 Sun Microsystems, Inc. All rights reserved.
*
* The contents of this file are subject to the terms of either the GNU
* General Public License Version 2 only ("GPL") or the Common Development
* and Distribution License("CDDL") (collectively, the "License").  You
* may not use this file except in compliance with the License. You can obtain
* a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
* or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
* language governing permissions and limitations under the License.
*
* When distributing the software, include this License Header Notice in each
* file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
* Sun designates this particular file as subject to the "Classpath" exception
* as provided by Sun in the GPL Version 2 section of the License file that
* accompanied this code.  If applicable, add the following below the License
* Header, with the fields enclosed by brackets [] replaced by your own
* identifying information: "Portions Copyrighted [year]
* [name of copyright owner]"
*
* Contributor(s):
*
* If you wish your version of this file to be governed by only the CDDL or
* only the GPL Version 2, indicate your decision by adding "[Contributor]
* elects to include this software in this distribution under the [CDDL or GPL
* Version 2] license."  If you don't indicate a single choice of license, a
* recipient has the option to distribute your version of this file under
* either the CDDL, the GPL Version 2 or to extend the choice of license to
* its licensees as provided above.  However, if you add GPL Version 2 code
* and therefore, elected the GPL Version 2 license, then the option applies
* only if the new code is made subject to such option by the copyright
* holder.
*/
package org.atmosphere.jersey;

import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.spi.inject.Injectable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.atmosphere.cpr.Broadcaster;

import javax.ws.rs.core.Context;
import java.lang.reflect.Type;

/**
 * Allow {@link Broadcaster} injection via the {@link Context} annotation supported
 * by Jersey.
 *
 * @author Jeanfrancois Arcand
  * @author Paul Sandoz
*/
abstract class BroadcasterInjector extends BaseInjectableProvider {

    boolean isValidType(Type t) {
        return (t instanceof Class) && Broadcaster.class.isAssignableFrom((Class)t);            
    }

    public static final class PerRequest extends BroadcasterInjector {
        @Override
        public ComponentScope getScope() {
            return ComponentScope.PerRequest;
        }

        @Override
        public Injectable getInjectable(ComponentContext ic, Context a, Type t) {
            if (!isValidType(t))
                return null;

            return new Injectable<Broadcaster>() {
                @Override
                public Broadcaster getValue() {
                    return getAtmosphereResource(Broadcaster.class, true).getBroadcaster();
                }
            };
        }
    }

    public static final class Singleton extends BroadcasterInjector {
        @Override
        public ComponentScope getScope() {
            return ComponentScope.Singleton;
        }

        @Override
        public Injectable getInjectable(ComponentContext ic, Context a, Type t) {
            if (!isValidType(t))
                return null;

            return new Injectable<Broadcaster>() {
                @Override
                public Broadcaster getValue() {
                    return (Broadcaster)Proxy.newProxyInstance(this.getClass().getClassLoader(),
                            new Class[] { Broadcaster.class },
                            new InvocationHandler() {
                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            return method.invoke(getAtmosphereResource(Broadcaster.class, true).getBroadcaster(),
                                    args);
                        }
                    });

                }
            };
        }
    }
}
