/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jersey.util;

import com.sun.jersey.spi.container.ContainerResponse;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Response;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.jersey.AtmosphereFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JerseyBroadcasterUtil {
    private static final Logger logger = LoggerFactory.getLogger(JerseyBroadcasterUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void broadcast(AtmosphereResource r, AtmosphereResourceEvent e, Broadcaster broadcaster) {
        AtmosphereRequest request = r.getRequest();
        ContainerResponse cr = null;
        cr = (ContainerResponse)request.getAttribute("org.atmosphere.jersey.containerResponse");
        boolean isCancelled = r.getAtmosphereResourceEvent().isCancelled();
        if (cr == null || isCancelled) {
            logger.debug("Retrieving HttpServletRequest {} with ContainerResponse {}", (Object)request, (Object)cr);
            if (!isCancelled) {
                logger.debug("Unexpected state. ContainerResponse cannot be null or already committed. The connection hasn't been suspended yet");
            } else {
                logger.debug("ContainerResponse already resumed or cancelled. Ignoring");
            }
            if (DefaultBroadcaster.class.isAssignableFrom(broadcaster.getClass())) {
                ((DefaultBroadcaster)DefaultBroadcaster.class.cast(broadcaster)).cacheLostMessage(r);
            }
            AsynchronousProcessor.destroyResource((AtmosphereResource)r);
            return;
        }
        ContainerResponse containerResponse = cr;
        synchronized (containerResponse) {
            try {
                String m = null;
                if (request.getAttribute(FrameworkConfig.EXPECTED_CONTENT_TYPE) != null) {
                    m = (String)request.getAttribute(FrameworkConfig.EXPECTED_CONTENT_TYPE);
                }
                if (m == null || m.equalsIgnoreCase("text/event-stream")) {
                    if (cr.getHttpHeaders().getFirst((Object)"Content-Type") != null) {
                        m = cr.getHttpHeaders().getFirst((Object)"Content-Type").toString();
                    }
                    if ((m == null || m.equalsIgnoreCase("application/octet-stream")) && (m = r.getAtmosphereConfig().getInitParameter("org.atmosphere.sse.contentType")) == null) {
                        m = "text/plain";
                    }
                }
                if (e.getMessage() instanceof Response) {
                    cr.setResponse((Response)e.getMessage());
                    cr.getHttpHeaders().add((Object)"Content-Type", (Object)m);
                    cr.write();
                    if (!cr.isCommitted()) {
                        cr.getOutputStream().flush();
                    }
                } else if (e.getMessage() instanceof List) {
                    for (Object msg : (List)e.getMessage()) {
                        cr.setResponse(Response.ok(msg).build());
                        cr.getHttpHeaders().add((Object)"Content-Type", (Object)m);
                        cr.write();
                        if (cr.isCommitted()) continue;
                        cr.getOutputStream().flush();
                    }
                } else {
                    if (e.getMessage() == null) {
                        logger.warn("Broadcasted message is null");
                        return;
                    }
                    cr.setResponse(Response.ok((Object)e.getMessage()).build());
                    cr.getHttpHeaders().add((Object)"Content-Type", (Object)m);
                    cr.write();
                    if (!cr.isCommitted()) {
                        cr.getOutputStream().flush();
                    }
                }
            }
            catch (Throwable t) {
                if (DefaultBroadcaster.class.isAssignableFrom(broadcaster.getClass())) {
                    ((DefaultBroadcaster)DefaultBroadcaster.class.cast(broadcaster)).onException(t, r);
                } else {
                    JerseyBroadcasterUtil.onException(t, r);
                }
            }
            finally {
                Boolean resumeOnBroadcast;
                if (cr != null) {
                    cr.setEntity(null);
                }
                if ((resumeOnBroadcast = (Boolean)request.getAttribute("org.atmosphere.resumeOnBroadcast")) != null && resumeOnBroadcast.booleanValue()) {
                    String uuid = (String)request.getAttribute(AtmosphereFilter.RESUME_UUID);
                    if (uuid != null && request.getAttribute(AtmosphereFilter.RESUME_CANDIDATES) != null) {
                        ((ConcurrentHashMap)request.getAttribute(AtmosphereFilter.RESUME_CANDIDATES)).remove(uuid);
                    }
                    r.resume();
                }
            }
        }
    }

    static final void onException(Throwable t, AtmosphereResource r) {
        logger.trace("onException()", t);
        r.notifyListeners((AtmosphereResourceEvent)new AtmosphereResourceEventImpl((AtmosphereResourceImpl)r, true, false));
        AsynchronousProcessor.destroyResource((AtmosphereResource)r);
    }
}

