/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jersey;

import org.atmosphere.cpr.Broadcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Broadcastable {
    private static final Logger logger = LoggerFactory.getLogger(Broadcastable.class);
    private final Object message;
    private final Broadcaster b;
    private final Object callerMessage;

    public Broadcastable(Broadcaster b) {
        this.b = b;
        this.message = "";
        this.callerMessage = "";
    }

    public Broadcastable(Object message, Broadcaster b) {
        this.b = b;
        this.message = message;
        this.callerMessage = message;
    }

    public Broadcastable(Object message, Object callerMessage, Broadcaster b) {
        this.b = b;
        this.message = message;
        this.callerMessage = callerMessage;
        if (callerMessage == null) {
            throw new NullPointerException("callerMessage cannot be null");
        }
    }

    public Object broadcast() {
        try {
            return this.b.broadcast(this.message).get();
        }
        catch (Exception ex) {
            logger.error("failed to broadcast message: " + this.message, (Throwable)ex);
            return null;
        }
    }

    public Object getMessage() {
        return this.message;
    }

    public Broadcaster getBroadcaster() {
        return this.b;
    }

    public Object getResponseMessage() {
        return this.callerMessage;
    }
}

