/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.ServletException;
import org.atmosphere.container.Jetty7CometSupport;
import org.atmosphere.container.JettyWebSocketUtil;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.eclipse.jetty.websocket.WebSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyAsyncSupportWithWebSocket
extends Jetty7CometSupport {
    private static final Logger logger = LoggerFactory.getLogger(JettyAsyncSupportWithWebSocket.class);
    private final WebSocketFactory webSocketFactory;

    public JettyAsyncSupportWithWebSocket(AtmosphereConfig config) {
        super(config);
        WebSocketFactory wsf;
        try {
            String[] jettyVersion = config.getServletContext().getServerInfo().substring(6).split("\\.");
            wsf = Integer.valueOf(jettyVersion[0]) > 7 || Integer.valueOf(jettyVersion[0]) == 7 && Integer.valueOf(jettyVersion[1]) > 4 ? JettyWebSocketUtil.getFactory(config) : null;
        }
        catch (Throwable e) {
            try {
                logger.trace("Unable to parse Jetty version {}", (Object)config.getServletContext().getServerInfo());
            }
            catch (Throwable t) {
                // empty catch block
            }
            wsf = JettyWebSocketUtil.getFactory(config);
        }
        this.webSocketFactory = wsf;
    }

    @Override
    public AtmosphereFramework.Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        AtmosphereFramework.Action action = JettyWebSocketUtil.doService(this, req, res, this.webSocketFactory);
        return action == null ? super.service(req, res) : action;
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }
}

