/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReflectorAtmosphereHandler
implements AtmosphereHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractReflectorAtmosphereHandler.class);

    @Override
    public void onStateChange(AtmosphereResourceEvent event) throws IOException {
        Object o;
        Object message = event.getMessage();
        if (message == null || event.isCancelled() || event.getResource().getRequest().destroyed()) {
            return;
        }
        if (event.getResource().getSerializer() != null) {
            try {
                event.getResource().getSerializer().write((OutputStream)event.getResource().getResponse().getOutputStream(), message);
            }
            catch (Throwable ex) {
                logger.warn("Serializer exception: message: " + message, ex);
                throw new IOException(ex);
            }
        }
        boolean isUsingStream = (Boolean)event.getResource().getRequest().getAttribute("org.atmosphere.useStream");
        if (!isUsingStream) {
            try {
                event.getResource().getResponse().getWriter();
            }
            catch (IllegalStateException e) {
                isUsingStream = true;
            }
        }
        if (message instanceof List) {
            for (String s : (List)message) {
                if (isUsingStream) {
                    event.getResource().getResponse().getOutputStream().write(s.getBytes());
                    event.getResource().getResponse().getOutputStream().flush();
                    continue;
                }
                event.getResource().getResponse().getWriter().write(s);
                event.getResource().getResponse().getWriter().flush();
            }
        } else if (isUsingStream) {
            event.getResource().getResponse().getOutputStream().write(message.toString().getBytes());
            event.getResource().getResponse().getOutputStream().flush();
        } else {
            event.getResource().getResponse().getWriter().write(message.toString());
            event.getResource().getResponse().getWriter().flush();
        }
        Boolean resumeOnBroadcast = event.getResource().resumeOnBroadcast();
        if (!resumeOnBroadcast.booleanValue() && (o = event.getResource().getRequest().getAttribute("org.atmosphere.resumeOnBroadcast")) != null && Boolean.class.isAssignableFrom(o.getClass())) {
            resumeOnBroadcast = (Boolean)Boolean.class.cast(o);
        }
        if (resumeOnBroadcast != null && resumeOnBroadcast.booleanValue()) {
            event.getResource().resume();
        }
    }
}

