/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jetty;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.jetty.JettyWebSocketDraft08Handler;
import org.atmosphere.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketDraft08Servlet
extends WebSocketServlet {
    protected static final Logger logger = LoggerFactory.getLogger(JettyWebSocketDraft08Servlet.class);
    protected AtmosphereFramework framework;

    public JettyWebSocketDraft08Servlet() {
        this(false);
    }

    public JettyWebSocketDraft08Servlet(boolean isFilter) {
        this(isFilter, true);
    }

    public JettyWebSocketDraft08Servlet(boolean isFilter, boolean autoDetectHandlers) {
        this.framework = new AtmosphereFramework(isFilter, autoDetectHandlers);
    }

    public void destroy() {
        this.framework.destroy();
    }

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.framework.init(sc);
    }

    public AtmosphereFramework framework() {
        return this.framework;
    }

    public void doHead(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doOptions(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doTrace(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.framework.doCometSupport(AtmosphereRequest.wrap(req), AtmosphereResponse.wrap(res));
    }

    public org.eclipse.jetty.websocket.WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        logger.debug("WebSocket upgrade requested");
        request.setAttribute(WebSocket.WEBSOCKET_INITIATED, (Object)true);
        return new JettyWebSocketDraft08Handler(AtmosphereRequest.loadInMemory(request, false), this.framework, this.framework.getWebSocketProtocol());
    }
}

