/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.io.IOException;
import java.io.PrintWriter;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AsyncIOWriterAdapter;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSEAtmosphereInterceptor
implements AtmosphereInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(SSEAtmosphereInterceptor.class);
    private static final StringBuffer whitespace = new StringBuffer();

    @Override
    public Action inspect(AtmosphereResource r) {
        final AtmosphereResponse response = r.getResponse();
        if (r.transport().equals((Object)AtmosphereResource.TRANSPORT.SSE)) {
            String contentType = response.getContentType();
            response.setContentType("text/event-stream");
            response.setCharacterEncoding("utf-8");
            PrintWriter writer = null;
            try {
                writer = response.getWriter();
            }
            catch (IOException e) {
                logger.trace("", (Throwable)e);
            }
            writer.print(whitespace);
            writer.flush();
            response.setContentType(contentType);
            response.asyncIOWriter(new AsyncIOWriterAdapter(){

                @Override
                public AsyncIOWriter redirect(String location) throws IOException {
                    response.sendRedirect(location);
                    return this;
                }

                @Override
                public AsyncIOWriter writeError(int errorCode, String message) throws IOException {
                    response.sendError(errorCode);
                    return this;
                }

                @Override
                public AsyncIOWriter write(String data) throws IOException {
                    response.write("data:" + data + "\n\n");
                    return this;
                }

                @Override
                public AsyncIOWriter write(byte[] data) throws IOException {
                    response.write("data:").write(data).write("\n\n");
                    return this;
                }

                @Override
                public AsyncIOWriter write(byte[] data, int offset, int length) throws IOException {
                    response.write("data:").write(data, offset, length).write("\n\n");
                    return this;
                }

                @Override
                public void close() throws IOException {
                    response.closeStreamOrWriter();
                }

                @Override
                public AsyncIOWriter flush() throws IOException {
                    response.flushBuffer();
                    return this;
                }
            });
        }
        return Action.CONTINUE;
    }

    public String toString() {
        return "SSE Interceptor Support";
    }

    static {
        for (int i = 0; i < 2000; ++i) {
            whitespace.append(" ");
        }
        whitespace.append("\n");
    }
}

