/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jetty;

import java.io.IOException;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocket
extends WebSocket {
    private static final Logger logger = LoggerFactory.getLogger(JettyWebSocket.class);
    private final WebSocket.Outbound outbound;
    private final byte frame = 0;

    public JettyWebSocket(WebSocket.Outbound outbound, AtmosphereConfig config) {
        super(config);
        this.outbound = outbound;
    }

    @Override
    public WebSocket writeError(AtmosphereResponse r, int errorCode, String message) throws IOException {
        logger.debug("{} {}", (Object)errorCode, (Object)message);
        return this;
    }

    @Override
    public WebSocket redirect(AtmosphereResponse r, String location) throws IOException {
        logger.error("redirect not supported");
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, String data) throws IOException {
        if (!this.outbound.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        this.outbound.sendMessage((byte)0, data);
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, byte[] data) throws IOException {
        if (!this.outbound.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        this.outbound.sendMessage((byte)0, data, 0, data.length);
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, byte[] data, int offset, int length) throws IOException {
        if (!this.outbound.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        this.outbound.sendMessage((byte)0, data, offset, length);
        return this;
    }

    @Override
    public void close(AtmosphereResponse r) throws IOException {
        this.outbound.disconnect();
    }

    @Override
    public WebSocket flush(AtmosphereResponse r) throws IOException {
        return this;
    }
}

