/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jetty;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketResponseFilter;
import org.eclipse.jetty.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocket
extends WebSocket {
    private static final Logger logger = LoggerFactory.getLogger(JettyWebSocket.class);
    private final WebSocket.Outbound outbound;
    private final byte frame = 0;
    private final AtomicBoolean firstWrite = new AtomicBoolean(false);

    public JettyWebSocket(WebSocket.Outbound outbound, AtmosphereConfig config) {
        super(config);
        this.outbound = outbound;
    }

    @Override
    public WebSocket writeError(AtmosphereResponse r, int errorCode, String message) throws IOException {
        if (!this.firstWrite.get()) {
            logger.debug("The WebSocket handshake succeeded but the dispatched URI failed {}:{}. The WebSocket connection is still open and client can continue sending messages.", (Object)message, (Object)errorCode);
        } else {
            logger.debug("{} {}", (Object)errorCode, (Object)message);
        }
        return this;
    }

    @Override
    public WebSocket redirect(AtmosphereResponse r, String location) throws IOException {
        logger.error("redirect not supported");
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, String data) throws IOException {
        this.firstWrite.set(true);
        if (!this.outbound.isOpen()) {
            throw new IOException("outbound remotely closed");
        }
        logger.trace("WebSocket.write()");
        if (this.binaryWrite) {
            byte[] b = this.webSocketResponseFilter.filter(r, data.getBytes(this.resource().getResponse().getCharacterEncoding()));
            if (b != null) {
                this.outbound.sendMessage((byte)0, b, 0, b.length);
            }
        } else {
            String s = this.webSocketResponseFilter.filter(r, data);
            if (s != null) {
                this.outbound.sendMessage(s);
            }
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, byte[] data) throws IOException {
        this.firstWrite.set(true);
        if (!this.outbound.isOpen()) {
            throw new IOException("outbound remotely closed");
        }
        logger.trace("WebSocket.write()");
        if (this.binaryWrite) {
            byte[] b = this.webSocketResponseFilter.filter(r, data);
            if (b != null) {
                this.outbound.sendMessage((byte)0, b, 0, b.length);
            }
        } else {
            byte[] s = this.webSocketResponseFilter.filter(r, data);
            if (s != null) {
                this.outbound.sendMessage(new String(s, r.getCharacterEncoding()));
            }
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, byte[] data, int offset, int length) throws IOException {
        this.firstWrite.set(true);
        if (!this.outbound.isOpen()) {
            throw new IOException("outbound remotely closed");
        }
        logger.trace("WebSocket.write()");
        if (this.binaryWrite) {
            if (!WebSocketResponseFilter.NoOpsWebSocketResponseFilter.class.isAssignableFrom(this.webSocketResponseFilter.getClass())) {
                byte[] b = this.webSocketResponseFilter.filter(r, data, offset, length);
                if (b != null) {
                    this.outbound.sendMessage((byte)0, b, 0, b.length);
                }
            } else {
                this.outbound.sendMessage((byte)0, data, offset, length);
            }
        } else {
            String s = this.webSocketResponseFilter.filter(r, new String(data, offset, length, "UTF-8"));
            if (s != null) {
                this.outbound.sendMessage(s);
            }
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public void close(AtmosphereResponse r) throws IOException {
        this.outbound.disconnect();
    }

    @Override
    public WebSocket flush(AtmosphereResponse r) throws IOException {
        return this;
    }
}

