/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jetty;

import java.io.UnsupportedEncodingException;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.jetty.JettyWebSocket;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.eclipse.jetty.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketDraft08Handler
implements WebSocket {
    private static final Logger logger = LoggerFactory.getLogger(JettyWebSocketDraft08Handler.class);
    private WebSocketProcessor webSocketProcessor;
    private final AtmosphereRequest request;
    private final AtmosphereFramework framework;
    private final WebSocketProtocol webSocketProtocol;

    public JettyWebSocketDraft08Handler(AtmosphereRequest request, AtmosphereFramework framework, WebSocketProtocol webSocketProtocol) {
        this.request = request;
        this.framework = framework;
        this.webSocketProtocol = webSocketProtocol;
    }

    public void onConnect(WebSocket.Outbound outbound) {
        logger.debug("WebSocket.onConnect (outbound)");
        try {
            this.webSocketProcessor = new WebSocketProcessor(this.framework, new JettyWebSocket(outbound, this.framework.getAtmosphereConfig()), this.webSocketProtocol);
            this.webSocketProcessor.dispatch(this.request);
        }
        catch (Exception e) {
            logger.warn("failed to connect to web socket", (Throwable)e);
        }
    }

    public void onMessage(byte frame, String data) {
        logger.trace("WebSocket.onMessage (frame/string)");
        this.webSocketProcessor.invokeWebSocketProtocol(data);
        this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent(data, WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, this.webSocketProcessor.webSocket()));
    }

    public void onMessage(byte frame, byte[] data, int offset, int length) {
        logger.trace("WebSocket.onMessage (frame)");
        this.webSocketProcessor.invokeWebSocketProtocol(new String(data, offset, length));
        try {
            this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent(new String(data, offset, length, "UTF-8"), WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, this.webSocketProcessor.webSocket()));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("UnsupportedEncodingException", (Throwable)e);
        }
    }

    public void onFragment(boolean more, byte opcode, byte[] data, int offset, int length) {
        logger.trace("WebSocket.onFragment");
        this.webSocketProcessor.invokeWebSocketProtocol(new String(data, offset, length));
        try {
            this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent(new String(data, offset, length, "UTF-8"), WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, this.webSocketProcessor.webSocket()));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("UnsupportedEncodingException", (Throwable)e);
        }
    }

    public void onDisconnect() {
        this.request.destroy();
        logger.trace("WebSocket.onDisconnect");
        this.webSocketProcessor.close(1000);
        this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent("", WebSocketEventListener.WebSocketEvent.TYPE.DISCONNECT, this.webSocketProcessor.webSocket()));
    }
}

