/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyCometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(JettyCometSupport.class);
    private final ConcurrentLinkedQueue<Continuation> resumed = new ConcurrentLinkedQueue();

    public JettyCometSupport(AtmosphereConfig config) {
        super(config);
    }

    @Override
    public AtmosphereFramework.Action service(AtmosphereRequest req, AtmosphereResponse response) throws IOException, ServletException {
        Continuation c = ContinuationSupport.getContinuation((HttpServletRequest)req, null);
        AtmosphereFramework.Action action = null;
        if (!c.isResumed() && !c.isPending() && req.getAttribute("doNotSuspend") == null) {
            action = this.suspended(req, response);
            if (action.type == AtmosphereFramework.Action.TYPE.SUSPEND) {
                logger.debug("Suspending response: {}", (Object)response);
                if (action.timeout != -1L) {
                    c.suspend(action.timeout);
                } else {
                    c.suspend(0L);
                }
            } else if (action.type == AtmosphereFramework.Action.TYPE.RESUME) {
                logger.debug("Resuming response: {}", (Object)response);
                if (!this.resumed.remove(c)) {
                    c.reset();
                    if (req.getAttribute(ApplicationConfig.RESUMED_ON_TIMEOUT) == null) {
                        this.timedout(req, response);
                    } else {
                        this.resumed(req, response);
                    }
                }
            }
        } else {
            logger.debug("Resuming response: {}", (Object)response);
            if (!this.resumed.remove(c) && req.getAttribute("doNotSuspend") == null) {
                c.reset();
                if (req.getAttribute(ApplicationConfig.RESUMED_ON_TIMEOUT) == null) {
                    this.timedout(req, response);
                } else {
                    this.resumed(req, response);
                }
            }
        }
        return action;
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
        super.action(r);
        if (r.action().type == AtmosphereFramework.Action.TYPE.RESUME && r.isInScope()) {
            Continuation c = ContinuationSupport.getContinuation((HttpServletRequest)r.getRequest(), null);
            this.resumed.offer(c);
            if (this.config.getInitParameter(ApplicationConfig.RESUME_AND_KEEPALIVE) == null || this.config.getInitParameter(ApplicationConfig.RESUME_AND_KEEPALIVE).equalsIgnoreCase("false")) {
                if (!c.isNew()) {
                    c.resume();
                } else {
                    r.getRequest().setAttribute("doNotSuspend", true);
                }
            } else {
                try {
                    r.getResponse().flushBuffer();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public AtmosphereFramework.Action cancelled(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Continuation c;
        AtmosphereFramework.Action action = super.cancelled(req, res);
        if (req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity") != null && (Long)Long.class.cast(req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity")) == -1L && (c = ContinuationSupport.getContinuation((HttpServletRequest)req, null)) != null) {
            c.resume();
        }
        return action;
    }
}

