/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.util.Base64;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.atmosphere.container.Servlet30CometSupport;
import org.atmosphere.container.TomcatWebSocketHandler;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tomcat7AsyncSupportWithWebSocket
extends Servlet30CometSupport {
    private static final Logger logger = LoggerFactory.getLogger(Tomcat7AsyncSupportWithWebSocket.class);
    private static final long serialVersionUID = 1L;
    private static byte[] WS_ACCEPT;
    private Queue<MessageDigest> sha1Helpers = new ConcurrentLinkedQueue<MessageDigest>();

    public Tomcat7AsyncSupportWithWebSocket(AtmosphereConfig config) {
        super(config);
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        try {
            WS_ACCEPT = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes("ISO_8859_1");
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    @Override
    public AtmosphereFramework.Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        if (req.getAttribute(WebSocket.WEBSOCKET_SUSPEND) == null) {
            String subProtocol = null;
            if (!this.headerContainsToken(req, "upgrade", "websocket")) {
                return super.service(req, res);
            }
            if (!this.headerContainsToken(req, "connection", "upgrade")) {
                return super.service(req, res);
            }
            if (!this.headerContainsToken(req, "sec-websocket-version", "13")) {
                logger.debug("WebSocket version not supported. Downgrading to Comet");
                res.sendError(202, "Websocket protocol not supported");
                return new AtmosphereFramework.Action(AtmosphereFramework.Action.TYPE.CANCELLED);
            }
            String key = req.getHeader("Sec-WebSocket-Key");
            if (key == null) {
                return super.service(req, res);
            }
            res.setHeader("upgrade", "websocket");
            res.setHeader("connection", "upgrade");
            res.setHeader("Sec-WebSocket-Accept", this.getWebSocketAccept(key));
            if (subProtocol != null) {
                res.setHeader("Sec-WebSocket-Protocol", subProtocol);
            }
            RequestFacade facade = (RequestFacade)req.wrappedRequest();
            TomcatWebSocketHandler inbound = new TomcatWebSocketHandler(AtmosphereRequest.loadInMemory(req, true), this.config.framework(), this.config.framework().getWebSocketProtocol());
            facade.doUpgrade((UpgradeInbound)inbound);
        }
        AtmosphereFramework.Action action = this.suspended(req, res);
        if (action.type == AtmosphereFramework.Action.TYPE.SUSPEND) {
            logger.debug("Suspending resonse: {}", (Object)res);
        } else if (action.type == AtmosphereFramework.Action.TYPE.RESUME) {
            logger.debug("Resume resonse: {}", (Object)res);
            req.setAttribute(WebSocket.WEBSOCKET_RESUME, true);
        }
        return action;
    }

    private boolean headerContainsToken(HttpServletRequest req, String headerName, String target) {
        Enumeration headers = req.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            for (String token : tokens = header.split(",")) {
                if (!target.equalsIgnoreCase(token.trim())) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> getTokensFromHeader(HttpServletRequest req, String headerName) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration headers = req.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            for (String token : tokens = header.split(",")) {
                result.add(token.trim());
            }
        }
        return result;
    }

    private String getWebSocketAccept(String key) throws ServletException {
        MessageDigest sha1Helper = this.sha1Helpers.poll();
        if (sha1Helper == null) {
            try {
                sha1Helper = MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new ServletException((Throwable)e);
            }
        }
        sha1Helper.reset();
        try {
            sha1Helper.update(key.getBytes("ISO_8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ServletException((Throwable)e);
        }
        String result = Base64.encode((byte[])sha1Helper.digest(WS_ACCEPT));
        this.sha1Helpers.add(sha1Helper);
        return result;
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }
}

