/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereMappingException;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.cpr.Meteor;
import org.atmosphere.util.uri.UriTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsynchronousProcessor
implements AsyncSupport<AtmosphereResourceImpl> {
    private static final Logger logger = LoggerFactory.getLogger(AsynchronousProcessor.class);
    protected static final AtmosphereFramework.Action timedoutAction = new AtmosphereFramework.Action(AtmosphereFramework.Action.TYPE.TIMEOUT);
    protected static final AtmosphereFramework.Action cancelledAction = new AtmosphereFramework.Action(AtmosphereFramework.Action.TYPE.CANCELLED);
    private static final int DEFAULT_SESSION_TIMEOUT = 1800;
    protected final AtmosphereConfig config;
    protected final ConcurrentHashMap<AtmosphereRequest, AtmosphereResource> aliveRequests = new ConcurrentHashMap();
    private boolean trackActiveRequest = false;
    private final ScheduledExecutorService closedDetector = Executors.newScheduledThreadPool(1);

    public AsynchronousProcessor(AtmosphereConfig config) {
        this.config = config;
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        String maxInactive;
        String string = maxInactive = sc.getInitParameter("org.atmosphere.cpr.CometSupport.maxInactiveActivity") != null ? sc.getInitParameter("org.atmosphere.cpr.CometSupport.maxInactiveActivity") : this.config.getInitParameter("org.atmosphere.cpr.CometSupport.maxInactiveActivity");
        if (maxInactive != null) {
            this.trackActiveRequest = true;
            final long maxInactiveTime = Long.parseLong(maxInactive);
            if (maxInactiveTime <= 0L) {
                return;
            }
            this.closedDetector.scheduleAtFixedRate(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    for (AtmosphereRequest req : AsynchronousProcessor.this.aliveRequests.keySet()) {
                        long l = (Long)req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity");
                        if (l <= 0L || System.currentTimeMillis() - l <= maxInactiveTime) continue;
                        try {
                            logger.debug("Close detector disconnecting {}. Current size {}", (Object)req, (Object)AsynchronousProcessor.this.aliveRequests.size());
                            AtmosphereResourceImpl r = (AtmosphereResourceImpl)AsynchronousProcessor.this.aliveRequests.remove(req);
                            AsynchronousProcessor.this.cancelled(req, r.getResponse(false));
                        }
                        catch (Throwable e) {
                            logger.warn("closedDetector", e);
                        }
                        finally {
                            try {
                                req.setAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity", -1L);
                            }
                            catch (Throwable t) {
                                logger.trace("closedDetector", t);
                            }
                        }
                    }
                }
            }, 0L, 1L, TimeUnit.SECONDS);
        }
    }

    protected boolean supportSession() {
        return this.config.isSupportSession();
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo();
    }

    public AtmosphereFramework.Action suspended(AtmosphereRequest request, AtmosphereResponse response) throws IOException, ServletException {
        return this.action(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AtmosphereFramework.Action action(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        HttpSession session;
        boolean webSocketEnabled = false;
        if (req.getHeaders("Connection") != null && req.getHeaders("Connection").hasMoreElements()) {
            String[] e;
            for (String upgrade : e = req.getHeaders("Connection").nextElement().toString().split(",")) {
                if (!upgrade.equalsIgnoreCase("Upgrade")) continue;
                webSocketEnabled = true;
                break;
            }
        }
        if (webSocketEnabled && !this.supportWebSocket()) {
            res.setStatus(501);
            res.addHeader("X-Atmosphere-error", "Websocket protocol not supported");
            res.flushBuffer();
            return new AtmosphereFramework.Action();
        }
        if (this.config.handlers().isEmpty()) {
            logger.error("No AtmosphereHandler found. Make sure you define it inside META-INF/atmosphere.xml");
            throw new AtmosphereMappingException("No AtmosphereHandler found. Make sure you define it insides META-INF/atmosphere.xml");
        }
        if (this.supportSession() && (session = req.getSession(true)).getMaxInactiveInterval() == 1800) {
            session.setMaxInactiveInterval(-1);
        }
        req.setAttribute(FrameworkConfig.SUPPORT_SESSION, this.supportSession());
        AtmosphereFramework.AtmosphereHandlerWrapper handlerWrapper = this.map(req);
        Broadcaster b = handlerWrapper.broadcaster;
        if (b.isDestroyed()) {
            AtmosphereFramework.AtmosphereHandlerWrapper len$ = handlerWrapper;
            synchronized (len$) {
                this.config.getBroadcasterFactory().remove(b, b.getID());
                handlerWrapper.broadcaster = this.config.getBroadcasterFactory().get(b.getID());
            }
        }
        AtmosphereResourceImpl resource = new AtmosphereResourceImpl(this.config, handlerWrapper.broadcaster, req, res, this, handlerWrapper.atmosphereHandler);
        req.setAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE, resource);
        req.setAttribute(FrameworkConfig.ATMOSPHERE_HANDLER, handlerWrapper.atmosphereHandler);
        try {
            handlerWrapper.atmosphereHandler.onRequest(resource);
        }
        catch (IOException t) {
            resource.onThrowable(t);
            throw t;
        }
        if (this.trackActiveRequest && resource.getAtmosphereResourceEvent().isSuspended() && req.getAttribute("doNotSuspend") == null) {
            req.setAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity", System.currentTimeMillis());
            this.aliveRequests.put(req, resource);
        }
        return resource.action();
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
        if (this.trackActiveRequest) {
            this.aliveRequests.remove(r.getRequest(false));
        }
    }

    protected AtmosphereFramework.AtmosphereHandlerWrapper map(String path) {
        AtmosphereFramework.AtmosphereHandlerWrapper atmosphereHandlerWrapper = this.config.handlers().get(path);
        if (atmosphereHandlerWrapper == null) {
            HashMap<String, String> m = new HashMap<String, String>();
            for (Map.Entry<String, AtmosphereFramework.AtmosphereHandlerWrapper> e : this.config.handlers().entrySet()) {
                UriTemplate t = new UriTemplate(e.getKey());
                logger.trace("Trying to map {} to {}", (Object)t, (Object)path);
                if (!t.match((CharSequence)path, m)) continue;
                atmosphereHandlerWrapper = e.getValue();
                logger.trace("Mapped {} to {}", (Object)t, (Object)e.getValue());
                break;
            }
        }
        return atmosphereHandlerWrapper;
    }

    protected AtmosphereFramework.AtmosphereHandlerWrapper map(AtmosphereRequest req) throws ServletException {
        AtmosphereFramework.AtmosphereHandlerWrapper atmosphereHandlerWrapper;
        String path = req.getPathInfo() != null ? req.getServletPath() + req.getPathInfo() : req.getServletPath();
        if (path.isEmpty()) {
            path = "/";
        }
        if ((atmosphereHandlerWrapper = this.map(path)) == null) {
            if (!path.endsWith("/")) {
                atmosphereHandlerWrapper = this.map(path + "/");
            }
            if (atmosphereHandlerWrapper == null) {
                atmosphereHandlerWrapper = this.map("/all");
            }
        }
        if (atmosphereHandlerWrapper == null) {
            throw new AtmosphereMappingException("No AtmosphereHandler maps request for " + path);
        }
        this.config.getBroadcasterFactory().add(atmosphereHandlerWrapper.broadcaster, atmosphereHandlerWrapper.broadcaster.getID());
        return atmosphereHandlerWrapper;
    }

    public AtmosphereFramework.Action resumed(AtmosphereRequest request, AtmosphereResponse response) throws IOException, ServletException {
        return this.action(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AtmosphereFramework.Action timedout(AtmosphereRequest request, AtmosphereResponse response) throws IOException, ServletException {
        AtmosphereResourceImpl r = null;
        try {
            if (this.trackActiveRequest) {
                long l = (Long)request.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity");
                if (l == -1L) {
                    AtmosphereFramework.Action action = timedoutAction;
                    return action;
                }
                request.setAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity", -1L);
            }
            logger.debug("Timing out the connection for request {}", (Object)request);
            if (request == null || response == null) {
                logger.warn("Invalid Request/Response: {}/{}", (Object)request, (Object)response);
                AtmosphereFramework.Action l = timedoutAction;
                return l;
            }
            r = (AtmosphereResourceImpl)request.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
            if (r == null) return timedoutAction;
            if (!r.getAtmosphereResourceEvent().isSuspended()) return timedoutAction;
            r.getAtmosphereResourceEvent().setIsResumedOnTimeout(true);
            Broadcaster b = r.getBroadcaster();
            if (b instanceof DefaultBroadcaster) {
                ((DefaultBroadcaster)b).broadcastOnResume(r);
            }
            if (request.getAttribute(ApplicationConfig.RESUMED_ON_TIMEOUT) != null) {
                r.getAtmosphereResourceEvent().setIsResumedOnTimeout((Boolean)request.getAttribute(ApplicationConfig.RESUMED_ON_TIMEOUT));
            }
            this.invokeAtmosphereHandler(r);
            return timedoutAction;
        }
        catch (Throwable t) {
            logger.error("failed to timeout resource {}", (Object)r, (Object)t);
            return timedoutAction;
        }
        finally {
            try {
                if (r != null) {
                    r.notifyListeners();
                    r.setIsInScope(false);
                    r.cancel();
                }
            }
            catch (Throwable t) {
                logger.trace("timedout", t);
            }
            finally {
                try {
                    response.getOutputStream().close();
                }
                catch (Throwable t) {
                    try {
                        response.getWriter().close();
                    }
                    catch (Throwable t2) {}
                }
                if (r != null) {
                    AsynchronousProcessor.destroyResource(r);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeAtmosphereHandler(AtmosphereResourceImpl r) throws IOException {
        block9: {
            if (!r.isInScope()) {
                return;
            }
            AtmosphereRequest req = r.getRequest(false);
            String disableOnEvent = r.getAtmosphereConfig().getInitParameter("org.atmosphere.disableOnStateEvent");
            r.getAtmosphereResourceEvent().setMessage(r.writeOnTimeout());
            try {
                if (disableOnEvent != null && disableOnEvent.equals(String.valueOf(true))) break block9;
                AtmosphereHandler atmosphereHandler = (AtmosphereHandler)req.getAttribute(FrameworkConfig.ATMOSPHERE_HANDLER);
                AtmosphereResourceImpl atmosphereResourceImpl = r;
                synchronized (atmosphereResourceImpl) {
                    atmosphereHandler.onStateChange(r.getAtmosphereResourceEvent());
                    Meteor m = (Meteor)req.getAttribute(AtmosphereResourceImpl.METEOR);
                    if (m != null) {
                        m.destroy();
                    }
                }
                req.removeAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
            }
            catch (IOException ex) {
                try {
                    r.onThrowable(ex);
                }
                catch (Throwable t) {
                    logger.warn("failed calling onThrowable()", (Throwable)ex);
                }
            }
        }
    }

    public static void destroyResource(AtmosphereResource r) {
        if (r == null) {
            return;
        }
        try {
            r.removeEventListeners();
            try {
                ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).getBroadcaster(false).removeAtmosphereResource(r);
            }
            catch (IllegalStateException ex) {
                logger.trace(ex.getMessage(), (Throwable)ex);
            }
            if (BroadcasterFactory.getDefault() != null) {
                BroadcasterFactory.getDefault().removeAllAtmosphereResource(r);
            }
        }
        catch (Throwable t) {
            logger.trace("destroyResource", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AtmosphereFramework.Action cancelled(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        AtmosphereRequest atmosphereRequest = req;
        synchronized (atmosphereRequest) {
            AtmosphereResourceImpl r = null;
            try {
                if (this.trackActiveRequest) {
                    long l = (Long)req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity");
                    if (l == -1L) {
                        AtmosphereFramework.Action action = timedoutAction;
                        return action;
                    }
                    req.setAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity", -1L);
                }
                logger.debug("Cancelling the connection for request {}", (Object)req);
                r = (AtmosphereResourceImpl)req.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
                if (r == null) return cancelledAction;
                r.getAtmosphereResourceEvent().setCancelled(true);
                this.invokeAtmosphereHandler(r);
                try {
                    r.getResponse().getOutputStream().close();
                }
                catch (Throwable t) {
                    try {
                        r.getResponse().getWriter().close();
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable ex) {
                logger.debug("failed to cancel resource: " + r, ex);
            }
            finally {
                try {
                    if (r != null) {
                        r.notifyListeners();
                        r.setIsInScope(false);
                        r.cancel();
                    }
                }
                catch (Throwable t) {
                    logger.trace("cancel", t);
                }
                finally {
                    if (r != null) {
                        AsynchronousProcessor.destroyResource(r);
                    }
                }
            }
            return cancelledAction;
        }
    }

    protected void shutdown() {
        this.closedDetector.shutdownNow();
        for (AtmosphereResource resource : this.aliveRequests.values()) {
            try {
                resource.resume();
            }
            catch (Throwable t) {
                logger.debug("failed on resume: " + resource, t);
            }
        }
    }

    @Override
    public boolean supportWebSocket() {
        return false;
    }

    public static final class AsynchronousProcessorHook {
        private final AtmosphereResourceImpl r;

        public AsynchronousProcessorHook(AtmosphereResourceImpl r) {
            this.r = r;
            if (!AsynchronousProcessor.class.isAssignableFrom(r.asyncSupport.getClass())) {
                throw new IllegalStateException("AsyncSupport must extends AsynchronousProcessor");
            }
        }

        public void closed() {
            try {
                ((AsynchronousProcessor)this.r.asyncSupport).cancelled(this.r.getRequest(false), this.r.getResponse(false));
            }
            catch (IOException e) {
                logger.debug("", (Throwable)e);
            }
            catch (ServletException e) {
                logger.debug("", (Throwable)e);
            }
        }

        public void timedOut() {
            try {
                ((AsynchronousProcessor)this.r.asyncSupport).timedout(this.r.getRequest(false), this.r.getResponse(false));
            }
            catch (IOException e) {
                logger.debug("", (Throwable)e);
            }
            catch (ServletException e) {
                logger.debug("", (Throwable)e);
            }
        }

        public void resume() {
            ((AsynchronousProcessor)this.r.asyncSupport).action(this.r);
        }
    }
}

