/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.atmosphere.cpr.AsyncIOInterceptor;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AsyncIOWriterAdapter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereInterceptorWriter
extends AsyncIOWriterAdapter {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereInterceptorWriter.class);
    private final AtmosphereResponse response;
    private final ArrayList<AsyncIOInterceptor> filters = new ArrayList();

    public AtmosphereInterceptorWriter(AtmosphereResponse response) {
        this.response = response;
    }

    @Override
    public AsyncIOWriter redirect(String location) throws IOException {
        this.response.sendRedirect(location);
        return this;
    }

    @Override
    public AsyncIOWriter writeError(int errorCode, String message) throws IOException {
        this.response.sendError(errorCode);
        return this;
    }

    @Override
    public AsyncIOWriter write(String data) throws IOException {
        return this.write(data.getBytes(this.response.getCharacterEncoding()));
    }

    @Override
    public AsyncIOWriter write(byte[] data) throws IOException {
        return this.write(data, 0, data.length);
    }

    @Override
    public AsyncIOWriter write(byte[] data, int offset, int length) throws IOException {
        for (AsyncIOInterceptor i : this.filters) {
            i.prePayload(this.response, data, offset, length);
        }
        byte[] responseDraft = new byte[length];
        System.arraycopy(data, offset, responseDraft, 0, length);
        for (AsyncIOInterceptor i : this.filters) {
            responseDraft = i.transformPayload(responseDraft, data);
        }
        this.response.write(responseDraft);
        ArrayList reversedFilters = (ArrayList)this.filters.clone();
        Collections.reverse(reversedFilters);
        for (AsyncIOInterceptor i : reversedFilters) {
            i.postPayload(this.response, data, offset, length);
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        this.response.closeStreamOrWriter();
    }

    @Override
    public AsyncIOWriter flush() throws IOException {
        this.response.flushBuffer();
        return this;
    }

    public AtmosphereInterceptorWriter interceptor(AsyncIOInterceptor filter) {
        this.filters.add(filter);
        return this;
    }
}

