/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.cluster.jgroups;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.ClusterBroadcastFilter;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGroupsFilter
extends ReceiverAdapter
implements ClusterBroadcastFilter<String> {
    static final Logger logger = Logger.getLogger("JGroupsFilter");
    private JChannel jchannel;
    private String clusterName = "cluster-jgroups";
    private Broadcaster bc;
    private ConcurrentLinkedQueue<String> receivedMessages = new ConcurrentLinkedQueue();
    final List<String> state = new LinkedList<String>();

    public JGroupsFilter() {
        this(null);
    }

    public JGroupsFilter(Broadcaster bc) {
        this(bc, "atmosphere-framework");
    }

    public JGroupsFilter(Broadcaster bc, String containerName) {
        this(bc, containerName, "cluster-atmosphere");
    }

    public JGroupsFilter(Broadcaster bc, String containerName, String clusterName) {
        this.bc = bc;
        this.clusterName = clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void init() {
        try {
            logger.log(Level.INFO, "Starting Atmosphere JGroups Clustering support");
            this.jchannel = new JChannel();
            this.jchannel.setReceiver((Receiver)this);
            this.jchannel.connect(this.clusterName);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "", t);
        }
    }

    public void destroy() {
        this.jchannel.shutdown();
    }

    public void receive(Message message) {
        String msg = (String)message.getObject();
        if (message.getSrc() != this.jchannel.getLocalAddress() && msg != null) {
            this.receivedMessages.offer(msg);
            if (this.bc != null) {
                this.bc.broadcast((Object)msg);
            }
        }
    }

    public Object filter(Object o) {
        if (o instanceof String) {
            String message = (String)o;
            if (!this.receivedMessages.remove(message)) {
                try {
                    this.jchannel.send(new Message(null, null, (Serializable)((Object)message)));
                }
                catch (ChannelException e) {
                    logger.log(Level.WARNING, "", e);
                }
            }
            return message;
        }
        return o;
    }

    public Broadcaster getBroadcaster() {
        return this.bc;
    }

    public void setBroadcaster(Broadcaster bc) {
        this.bc = bc;
    }
}

