/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.jgroups;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import org.atmosphere.util.AbstractBroadcasterProxy;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsBroadcaster
extends AbstractBroadcasterProxy {
    private static final Logger logger = LoggerFactory.getLogger(JGroupsBroadcaster.class);
    private JChannel jchannel;
    private String clusterName = "atmosphere-jgroups";
    private final CountDownLatch ready = new CountDownLatch(1);

    public JGroupsBroadcaster() {
        this(JGroupsBroadcaster.class.getSimpleName());
    }

    public JGroupsBroadcaster(String id) {
        this(id, "atmosphere-jgroups");
    }

    public JGroupsBroadcaster(String id, String clusterName) {
        super(id);
        this.clusterName = clusterName + "-id";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingBroadcast() {
        try {
            logger.info("Starting Atmosphere JGroups Clustering support");
            this.jchannel = new JChannel();
            this.jchannel.setReceiver((Receiver)new ReceiverAdapter(){

                public void receive(Message message) {
                    String msg = (String)message.getObject();
                    if (msg != null) {
                        JGroupsBroadcaster.this.broadcastReceivedMessage(msg);
                    }
                }
            });
            this.jchannel.connect(this.clusterName);
        }
        catch (Throwable t) {
            logger.warn("failed to connect to JGroups channel", t);
        }
        finally {
            this.ready.countDown();
        }
    }

    public void outgoingBroadcast(Object message) {
        try {
            this.ready.await();
            this.jchannel.send(new Message(null, null, (Serializable)((Object)message.toString())));
        }
        catch (Throwable e) {
            logger.error("failed to send messge over Jgroups channel", (Object)e.getMessage());
        }
    }

    public void destroy() {
        super.destroy();
        this.jchannel.shutdown();
    }
}

